/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.DHBMParameterSpec;
import com.dstc.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DHBMParameters
extends AlgorithmParametersSpi {
    private DHBMParameterSpec paramsSpec;
    private DHBMParams params;

    protected byte[] engineGetEncoded() throws IOException {
        return this.params.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.getName().equals("com.dstc.security.provider.DHBMParameterSpec")) {
            throw new InvalidParameterSpecException(String.valueOf(clazz.getName()) + " not supported");
        }
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHBMParameterSpec)) {
            throw new InvalidParameterSpecException("Not a PBM param spec");
        }
        this.paramsSpec = (DHBMParameterSpec)algorithmParameterSpec;
        this.params = new DHBMParams(this.paramsSpec.getOwfAlgorithmId(), this.paramsSpec.getMacAlgorithmId());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.params = new DHBMParams(byArray);
            this.paramsSpec = new DHBMParameterSpec(this.params.owf_id, this.params.mac_id);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "DHBM Parameters";
    }

    protected class DHBMParams
    extends Sequence {
        private AlgorithmId owf_id;
        private AlgorithmId mac_id;

        protected DHBMParams(AlgorithmId algorithmId, AlgorithmId algorithmId2) {
            this.owf_id = algorithmId;
            this.addComponent(algorithmId);
            this.mac_id = algorithmId2;
            this.addComponent(algorithmId2);
        }

        protected DHBMParams(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            int n = 0;
            this.owf_id = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
            this.mac_id = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
        }
    }
}

