/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.atts.MessageDigest;
import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import com.dstc.security.provider.DHSignature;
import com.dstc.security.x509.Attribute;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;

public class DHEphemeralSignature
extends DHSignature {
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!privateKey.getAlgorithm().equals("DH")) {
            throw new InvalidKeyException("Not a DH Private Key");
        }
        this.CAPvt = (DHPrivateKey)privateKey;
        try {
            this.dhParamSpec = this.CAPvt.getParams();
            this.generateTempKeys();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!publicKey.getAlgorithm().equals("DH")) {
            throw new InvalidKeyException("Not a DH Public Key");
        }
        this.CAPub = (DHPublicKey)publicKey;
        try {
            this.bos = new ByteArrayOutputStream();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(exception.toString()) + " in engineInitVerify");
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            this.text = this.bos.toByteArray();
            this.p = this.dhParamSpec.getP();
            this.g = this.dhParamSpec.getG();
            this.l = this.dhParamSpec.getL();
            this.keyAgree = KeyAgreement.getInstance("DH", "DSTC");
            this.keyAgree.init(this.CAPvt);
            this.keyAgree.doPhase(this.dhPubKey, true);
            byte[] byArray = this.computeSign();
            DHSigEphemeral dHSigEphemeral = new DHSigEphemeral(this.p, this.g, this.l, this.dhPvtKey.getX(), byArray);
            return dHSigEphemeral.encode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SignatureException(exception.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            this.text = this.bos.toByteArray();
            DHSigEphemeral dHSigEphemeral = new DHSigEphemeral(byArray);
            this.p = ((DHSigEphemeral)dHSigEphemeral).domainParams.p;
            this.g = ((DHSigEphemeral)dHSigEphemeral).domainParams.g;
            this.l = ((DHSigEphemeral)dHSigEphemeral).domainParams.l;
            this.dhParamSpec = new DHParameterSpec(this.p, this.g, this.l);
            BigInteger bigInteger = dHSigEphemeral.tempPrivateKey;
            this.dhPvtKey = new DHPrivateKey(bigInteger, this.p, this.g, this.l);
            this.keyAgree = KeyAgreement.getInstance("DH", "DSTC");
            this.keyAgree.init(this.dhPvtKey);
            this.keyAgree.doPhase(this.CAPub, true);
            byte[] byArray2 = this.computeSign();
            return Arrays.equals(dHSigEphemeral.hashValue, byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SignatureException(exception.getMessage());
        }
    }

    private void generateTempKeys() {
        try {
            this.bos = new ByteArrayOutputStream();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH", "DSTC");
            keyPairGenerator.initialize(this.dhParamSpec);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            this.dhPvtKey = (DHPrivateKey)keyPair.getPrivate();
            this.dhPubKey = (DHPublicKey)keyPair.getPublic();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(exception.toString()) + " in keyGeneration()");
        }
    }

    protected class DHSigEphemeral
    extends Sequence {
        private DomainParameters domainParams;
        private BigInteger tempPrivateKey;
        private byte[] hashValue;

        protected DHSigEphemeral(BigInteger bigInteger, BigInteger bigInteger2, int n, BigInteger bigInteger3, byte[] byArray) {
            this.domainParams = new DomainParameters(bigInteger, bigInteger2, n);
            this.addComponent(this.domainParams);
            this.tempPrivateKey = bigInteger3;
            this.addComponent(new Integer(bigInteger3));
            this.hashValue = byArray;
            this.addComponent(new MessageDigest(byArray));
        }

        protected DHSigEphemeral(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            int n = 0;
            this.domainParams = new DomainParameters(((Asn1)this.components.elementAt(n++)).encode());
            this.tempPrivateKey = ((Integer)this.components.elementAt(n++)).getBigInteger();
            Attribute attribute = new Attribute(((Asn1)this.components.elementAt(n++)).encode());
            this.hashValue = ((OctetString)attribute.getValues().elementAt(0)).getBytes();
        }

        protected class DomainParameters
        extends Sequence {
            protected BigInteger p;
            protected BigInteger g;
            protected int l;

            protected DomainParameters(BigInteger bigInteger, BigInteger bigInteger2, int n) {
                this.p = bigInteger;
                this.addComponent(new Integer(bigInteger));
                this.g = bigInteger2;
                this.addComponent(new Integer(bigInteger2));
                this.l = n;
                this.addComponent(new Integer(n));
            }

            protected DomainParameters(byte[] byArray) throws Asn1Exception {
                this.doDecode(byArray);
                int n = 0;
                this.p = ((Integer)this.components.elementAt(n++)).getBigInteger();
                this.g = ((Integer)this.components.elementAt(n++)).getBigInteger();
                this.l = ((Integer)this.components.elementAt(n++)).getInt();
            }
        }
    }
}

