/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class DHKeyAgreement
extends KeyAgreementSpi {
    private SecureRandom random;
    private DHPrivateKey myPriv;
    private DHPublicKey yourPub;
    private BigInteger modulus;
    private BigInteger base;

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("Not a DH Public Key");
        }
        if (!bl) {
            throw new IllegalStateException("DH KeyAgreement has only two phases");
        }
        this.yourPub = (DHPublicKey)key;
        if (!this.yourPub.getParams().getG().equals(this.base) || !this.yourPub.getParams().getP().equals(this.modulus)) {
            throw new InvalidKeyException("Public/Private Key parameters mismatch");
        }
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.yourPub.getY().modPow(this.myPriv.getX(), this.modulus).toByteArray();
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray = this.yourPub.getY().modPow(this.myPriv.getX(), this.modulus).toByteArray();
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "DSTC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
            return secretKeyFactory.translateKey(secretKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " Not Found");
        }
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.yourPub.getY().modPow(this.myPriv.getX(), this.modulus).toByteArray();
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException("Buffer too short");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Not a DH Private Key");
        }
        this.random = secureRandom;
        this.myPriv = (DHPrivateKey)key;
        this.modulus = this.myPriv.getParams().getP();
        this.base = this.myPriv.getParams().getG();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Not a DH Private Key");
        }
        this.random = secureRandom;
        this.myPriv = (DHPrivateKey)key;
        this.modulus = this.myPriv.getParams().getP();
        this.base = this.myPriv.getParams().getG();
    }
}

