/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.pkcs8.PKCS5KeyDerivation;
import com.dstc.security.pkcs8.PKCS8EncryptedPrivateKey;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
            return new DHPrivateKey(dHPrivateKeySpec.getX(), dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG(), dHPrivateKeySpec.getL());
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                AlgorithmId algorithmId = privateKeyInfo.getAlgorithmId();
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmId.getParams().getParameterSpec(Class.forName("javax.crypto.spec.DHParameterSpec"));
                return new DHPrivateKey(privateKeyInfo.getEncodedKey(), dHParameterSpec);
            }
            catch (Exception exception) {
                try {
                    PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                    System.err.print("Enter password: ");
                    InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    PKCS5KeyDerivation pKCS5KeyDerivation = new PKCS5KeyDerivation();
                    pKCS8EncryptedPrivateKey.decrypt(bufferedReader.readLine(), pKCS5KeyDerivation);
                    return pKCS8EncryptedPrivateKey.getPrivateKey();
                }
                catch (ClassCastException classCastException) {
                }
                catch (Exception exception2) {
                    throw new InvalidKeySpecException("Bad key spec: wrong password?");
                }
            }
        }
        throw new InvalidKeySpecException("Not a DH private key spec");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPublicKeySpec) {
            DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
            return new DHPublicKey(dHPublicKeySpec.getY(), dHPublicKeySpec.getP(), dHPublicKeySpec.getG(), dHPublicKeySpec.getL());
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
            AlgorithmId algorithmId = subjectPublicKeyInfo.getAlgorithmId();
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmId.getParams().getParameterSpec(Class.forName("javax.crypto.spec.DHParameterSpec"));
            return new DHPublicKey(subjectPublicKeyInfo.getEncodedKey(), dHParameterSpec);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("Bad key spec");
        }
        throw new InvalidKeySpecException("Not a DH public key spec");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

