/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private SecureRandom random;
    private int keyLength;
    private BigInteger base;
    private BigInteger modulus;
    private int len;

    public KeyPair generateKeyPair() {
        BigInteger bigInteger = new BigInteger(this.keyLength, this.random);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInteger, this.modulus, this.base, this.len);
        BigInteger bigInteger2 = this.base.modPow(bigInteger, this.modulus);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInteger2, this.modulus, this.base, this.len);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.keyLength = n;
        if (n == 1024) {
            this.base = BigInteger.valueOf(2L);
            this.modulus = new BigInteger("179769313486231590770839156793787453197860296048756011706444423684197180216158519368947833795864925541502180565485980503646440548199239100050792877003355816639229553136239076508735759914822574862575007425302077447712589550957937778424442426617334727629299387668709205606050270810842907692932019128194467627007", 10);
        } else {
            try {
                AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DH", "DSTC");
                algorithmParameterGenerator.init(n, secureRandom);
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterGenerator.generateParameters().getParameterSpec(Class.forName("javax.crypto.spec.DHParameterSpec"));
                this.base = dHParameterSpec.getG();
                this.modulus = dHParameterSpec.getP();
                this.len = dHParameterSpec.getL();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not DH parameters");
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        this.keyLength = dHParameterSpec.getP().bitLength();
        this.base = dHParameterSpec.getG();
        this.modulus = dHParameterSpec.getP();
        this.len = dHParameterSpec.getL();
        this.random = secureRandom;
    }
}

