/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom random;
    private int keyLength;
    private int expSize;

    protected AlgorithmParameters engineGenerateParameters() {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", "DSTC");
            algorithmParameterGenerator.init(this.keyLength, this.random);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
            DHParameterSpec dHParameterSpec = new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG(), this.expSize);
            AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance("DH", "DSTC");
            algorithmParameters2.init(dHParameterSpec);
            return algorithmParameters2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.keyLength = n;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported param spec");
        }
        this.random = secureRandom;
        this.expSize = ((DHGenParameterSpec)algorithmParameterSpec).getExponentSize();
        this.keyLength = ((DHGenParameterSpec)algorithmParameterSpec).getPrimeSize();
    }
}

