/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class DHParameters
extends AlgorithmParametersSpi {
    private DHParameterSpec paramsSpec;
    private DHParams dhParams;

    protected byte[] engineGetEncoded() throws IOException {
        return this.dhParams.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Not a DH param spec");
        }
        this.paramsSpec = (DHParameterSpec)algorithmParameterSpec;
        this.dhParams = new DHParams(this.paramsSpec.getP(), this.paramsSpec.getG());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.dhParams = new DHParams(byArray);
            this.paramsSpec = new DHParameterSpec(this.dhParams.p, this.dhParams.g);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "DH Parameters";
    }

    protected class DHParams
    extends Sequence {
        private BigInteger g;
        private BigInteger p;
        private int l;

        protected DHParams(BigInteger bigInteger, BigInteger bigInteger2) {
            this.p = bigInteger;
            this.g = bigInteger2;
            this.addComponent(new Integer(bigInteger));
            this.addComponent(new Integer(bigInteger2));
        }

        protected DHParams(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.p = ((Integer)this.components.elementAt(0)).getBigInteger();
            this.g = ((Integer)this.components.elementAt(1)).getBigInteger();
        }
    }
}

