/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import javax.crypto.spec.DHParameterSpec;

public class DHPrivateKey
extends Integer
implements javax.crypto.interfaces.DHPrivateKey {
    private BigInteger x;
    private DHParameterSpec params;

    protected DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        super(bigInteger);
        this.x = bigInteger;
        this.params = new DHParameterSpec(bigInteger2, bigInteger3, n);
    }

    public DHPrivateKey(byte[] byArray, DHParameterSpec dHParameterSpec) throws Asn1Exception {
        this.doDecode(byArray);
        this.x = this.getBigInteger();
        this.params = dHParameterSpec;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DH", "DSTC");
            algorithmParameters.init(this.params);
            byte[] byArray = new PrivateKeyInfo(new AlgorithmId("1.2.840.113549.1.3.1", algorithmParameters), super.encode()).encode();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public BigInteger getX() {
        return this.x;
    }
}

