/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import javax.crypto.spec.DHParameterSpec;

public class DHPublicKey
extends Integer
implements javax.crypto.interfaces.DHPublicKey {
    private BigInteger y;
    private DHParameterSpec params;

    protected DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        super(bigInteger);
        this.y = bigInteger;
        this.params = new DHParameterSpec(bigInteger2, bigInteger3, n);
    }

    protected DHPublicKey(byte[] byArray, DHParameterSpec dHParameterSpec) throws Asn1Exception {
        this.doDecode(byArray);
        this.y = this.getBigInteger();
        this.params = dHParameterSpec;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DH", "DSTC");
            algorithmParameters.init(this.params);
            return new SubjectPublicKeyInfo(new AlgorithmId("1.2.840.113549.1.3.1", algorithmParameters), super.encode()).encode();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public BigInteger getY() {
        return this.y;
    }
}

