/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Integer;
import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.security.SignatureSpi;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class DHSignature
extends SignatureSpi {
    protected DHParameterSpec dhParamSpec;
    protected DHPublicKey dhPubKey;
    protected DHPrivateKey dhPvtKey;
    protected DHPrivateKey CAPvt;
    protected DHPublicKey CAPub;
    protected byte[] text;
    protected ByteArrayOutputStream bos;
    protected KeyAgreement keyAgree;
    protected BigInteger p;
    protected BigInteger g;
    protected int l;

    protected byte[] computeSign() throws SignatureException {
        try {
            byte[] byArray = this.keyAgree.generateSecret();
            byte[] byArray2 = new Integer(this.p).encode();
            byte[] byArray3 = new Integer(this.g).encode();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray2);
            messageDigest.update(byArray);
            messageDigest.update(byArray3);
            SecretKeySpec secretKeySpec = new SecretKeySpec(messageDigest.digest(), "DH");
            Mac mac = Mac.getInstance("HMACwithSHA1", "DSTC");
            mac.init(secretKeySpec, this.dhParamSpec);
            mac.update(this.text);
            byte[] byArray4 = mac.doFinal();
            return byArray4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SignatureException(exception.getMessage());
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected void engineSetParameters(String string, Object object) {
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bos.write(byArray, n, n2);
    }
}

