/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.pkcs8.PKCS5KeyDerivation;
import com.dstc.security.pkcs8.PKCS8EncryptedPrivateKey;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.provider.DSAPrivateKey;
import com.dstc.security.provider.DSAPublicKey;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
            return new DSAPrivateKey(dSAPrivateKeySpec.getX(), new DSAParameterSpec(dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG()));
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                AlgorithmId algorithmId = privateKeyInfo.getAlgorithmId();
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmId.getParams().getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
                return new DSAPrivateKey(privateKeyInfo.getEncodedKey(), dSAParameterSpec);
            }
            catch (Exception exception) {
                try {
                    PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                    System.err.print("Enter password: ");
                    InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    PKCS5KeyDerivation pKCS5KeyDerivation = new PKCS5KeyDerivation();
                    pKCS8EncryptedPrivateKey.decrypt(bufferedReader.readLine(), pKCS5KeyDerivation);
                    return pKCS8EncryptedPrivateKey.getPrivateKey();
                }
                catch (ClassCastException classCastException) {
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    throw new InvalidKeySpecException("Bad key spec: wrong password?");
                }
            }
        }
        throw new InvalidKeySpecException("Not a DSA private key spec");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
            return new DSAPublicKey(dSAPublicKeySpec.getY(), new DSAParameterSpec(dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG()));
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
            AlgorithmId algorithmId = subjectPublicKeyInfo.getAlgorithmId();
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmId.getParams().getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
            return new DSAPublicKey(subjectPublicKeyInfo.getEncodedKey(), dSAParameterSpec);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("Bad key spec");
        }
        throw new InvalidKeySpecException("Not a DSA public key spec");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (!key.getAlgorithm().equals("DSA")) {
            throw new InvalidKeySpecException("Cannot doDecode this key");
        }
        if (clazz.getName().equals("java.security.spec.X509EncodedKeySpec")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("Cannot convert to this key spec");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Not yet supported");
    }
}

