/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DSAPrivateKey;
import com.dstc.security.provider.DSAPublicKey;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public final class DSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DSAPrivateKey priv;
    private DSAPublicKey pub;
    private DSAParameterSpec dsaParamsSpec;
    private SecureRandom random;
    private int keyLength;

    public KeyPair generateKeyPair() {
        BigInteger bigInteger = new BigInteger(this.dsaParamsSpec.getQ().bitLength() - 1, this.random);
        this.priv = new DSAPrivateKey(bigInteger, this.dsaParamsSpec);
        BigInteger bigInteger2 = this.dsaParamsSpec.getG().modPow(bigInteger, this.dsaParamsSpec.getP());
        this.pub = new DSAPublicKey(bigInteger2, this.dsaParamsSpec);
        return new KeyPair(this.pub, this.priv);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.random = secureRandom;
        if (n == 1024) {
            this.dsaParamsSpec = new DSAParameterSpec(new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16), new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16), new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16));
            return;
        }
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", "DSTC");
            algorithmParameterGenerator.init(n, secureRandom);
            this.dsaParamsSpec = (DSAParameterSpec)algorithmParameterGenerator.generateParameters().getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a DSA parameter spec");
        }
        this.dsaParamsSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
    }
}

