/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAParameters
extends AlgorithmParametersSpi {
    private DSAParameterSpec paramsSpec;
    private DSAParams params;

    protected byte[] engineGetEncoded() throws IOException {
        return this.params.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.getName().equals("java.security.spec.DSAParameterSpec")) {
            throw new InvalidParameterSpecException(String.valueOf(clazz.getName()) + " not supported");
        }
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Not a DSA param spec");
        }
        this.paramsSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.params = new DSAParams(this.paramsSpec.getP(), this.paramsSpec.getQ(), this.paramsSpec.getG());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.params = new DSAParams(byArray);
            this.paramsSpec = new DSAParameterSpec(this.params.p, this.params.q, this.params.g);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "DSA Parameters";
    }

    protected class DSAParams
    extends Sequence {
        private BigInteger g;
        private BigInteger p;
        private BigInteger q;

        protected DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.p = bigInteger;
            this.q = bigInteger2;
            this.g = bigInteger3;
            this.addComponent(new Integer(bigInteger));
            this.addComponent(new Integer(bigInteger2));
            this.addComponent(new Integer(bigInteger3));
        }

        protected DSAParams(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.p = ((Integer)this.components.elementAt(0)).getBigInteger();
            this.q = ((Integer)this.components.elementAt(1)).getBigInteger();
            this.g = ((Integer)this.components.elementAt(2)).getBigInteger();
        }
    }
}

