/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public class DSAPrivateKey
extends Sequence
implements PrivateKey,
java.security.interfaces.DSAPrivateKey {
    private BigInteger x;
    private DSAParameterSpec dsaParamsSpec;

    protected DSAPrivateKey(BigInteger bigInteger, DSAParameterSpec dSAParameterSpec) {
        this.x = bigInteger;
        this.dsaParamsSpec = dSAParameterSpec;
    }

    public DSAPrivateKey(byte[] byArray, DSAParameterSpec dSAParameterSpec) throws Asn1Exception {
        Integer integer = (Integer)Asn1.decode(byArray);
        this.x = integer.getBigInteger();
        this.dsaParamsSpec = dSAParameterSpec;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA", "DSTC");
            algorithmParameters.init(this.dsaParamsSpec);
            byte[] byArray = new PrivateKeyInfo(new AlgorithmId("1.2.840.10040.4.1", algorithmParameters), new Integer(this.x).encode()).encode();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public DSAParams getParams() {
        return this.dsaParamsSpec;
    }

    public BigInteger getX() {
        return this.x;
    }
}

