/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public class DSAPublicKey
extends Integer
implements PublicKey,
java.security.interfaces.DSAPublicKey {
    private BigInteger y;
    private DSAParameterSpec dsaParamsSpec;

    protected DSAPublicKey(BigInteger bigInteger, DSAParameterSpec dSAParameterSpec) {
        super(bigInteger);
        this.y = bigInteger;
        this.dsaParamsSpec = dSAParameterSpec;
    }

    protected DSAPublicKey(byte[] byArray, DSAParameterSpec dSAParameterSpec) throws Asn1Exception {
        this.doDecode(byArray);
        this.y = this.getBigInteger();
        this.dsaParamsSpec = dSAParameterSpec;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA", "DSTC");
            algorithmParameters.init(this.dsaParamsSpec);
            return new SubjectPublicKeyInfo(new AlgorithmId("1.2.840.10040.4.1", algorithmParameters), super.encode()).encode();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public DSAParams getParams() {
        return this.dsaParamsSpec;
    }

    public BigInteger getY() {
        return this.y;
    }
}

