/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

public abstract class HMACwithAnyMD
extends MacSpi {
    protected byte ipadByte = (byte)54;
    protected byte opadByte = (byte)92;
    protected int L;
    protected int B = 64;
    protected MessageDigest md;
    protected byte[] keyXORIpad;
    protected byte[] keyXOROpad;

    protected byte[] engineDoFinal() {
        try {
            byte[] byArray = this.md.digest();
            this.md.reset();
            this.md.update(this.keyXOROpad);
            return this.md.digest(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void engineDoFinal(byte[] byArray, int n) {
        try {
            byte[] byArray2 = this.md.digest();
            this.md.reset();
            this.md.update(this.keyXOROpad);
            this.md.update(byArray2);
            byArray2 = this.md.digest();
            System.arraycopy(byArray2, 0, byArray, n, this.L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int engineGetMacLength() {
        return this.L;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyXORIpad = new byte[this.B];
        this.keyXOROpad = new byte[this.B];
        byte[] byArray = key.getEncoded();
        System.arraycopy(byArray, 0, this.keyXORIpad, 0, byArray.length);
        System.arraycopy(byArray, 0, this.keyXOROpad, 0, byArray.length);
        int n = 0;
        while (n < this.B) {
            int n2 = n;
            this.keyXORIpad[n2] = (byte)(this.keyXORIpad[n2] ^ this.ipadByte);
            int n3 = n++;
            this.keyXOROpad[n3] = (byte)(this.keyXOROpad[n3] ^ this.opadByte);
        }
        this.md.update(this.keyXORIpad);
    }

    protected void engineReset() {
        this.md.reset();
    }

    protected void engineUpdate(byte by) {
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }
}

