/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class PBEParameters
extends AlgorithmParametersSpi {
    private PBEParameterSpec paramsSpec;
    private PBEParams params;

    protected byte[] engineGetEncoded() throws IOException {
        return this.params.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Not a PBE param spec");
        }
        this.paramsSpec = (PBEParameterSpec)algorithmParameterSpec;
        this.params = new PBEParams(this.paramsSpec.getSalt(), this.paramsSpec.getIterationCount());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.params = new PBEParams(byArray);
            this.paramsSpec = new PBEParameterSpec(this.params.salt, this.params.ic);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "PBE Parameters";
    }

    protected class PBEParams
    extends Sequence {
        private byte[] salt;
        private int ic;

        protected PBEParams(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.salt = ((OctetString)this.components.elementAt(0)).getBytes();
            this.ic = ((Integer)this.components.elementAt(1)).getBigInteger().intValue();
        }

        protected PBEParams(byte[] byArray, int n) {
            this.salt = byArray;
            this.addComponent(new OctetString(byArray));
            this.ic = n;
            this.addComponent(new Integer(n));
        }
    }
}

