/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.pkcs12.PKCS12KeyDerivation;
import com.dstc.security.provider.PBECipher;
import com.dstc.security.provider.PBEKey;
import com.dstc.security.provider.RC4SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEwithSHAAnd40BitRC4
extends PBECipher {
    public PBEwithSHAAnd40BitRC4() {
        try {
            this.cipher = Cipher.getInstance("RC4", "DSTC");
            this.md = MessageDigest.getInstance("SHA", "DSTC");
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("Not a PBE Key");
        }
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidKeyException("Not PBE parameters");
        }
        PKCS12KeyDerivation pKCS12KeyDerivation = new PKCS12KeyDerivation();
        byte[] byArray = pKCS12KeyDerivation.generateKey(1, this.md, key, algorithmParameterSpec, 5);
        byte[] byArray2 = pKCS12KeyDerivation.generateKey(2, this.md, key, algorithmParameterSpec, 8);
        try {
            RC4SecretKey rC4SecretKey = new RC4SecretKey(byArray);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            this.cipher.init(n, rC4SecretKey, ivParameterSpec, secureRandom);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }
}

