/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.PBMParameterSpec;
import com.dstc.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class PBMParameters
extends AlgorithmParametersSpi {
    private PBMParameterSpec paramsSpec;
    private PBMParams params;

    protected byte[] engineGetEncoded() throws IOException {
        return this.params.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.getName().equals("com.dstc.security.provider.PBMParameterSpec")) {
            throw new InvalidParameterSpecException(String.valueOf(clazz.getName()) + " not supported");
        }
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBMParameterSpec)) {
            throw new InvalidParameterSpecException("Not a PBM param spec");
        }
        this.paramsSpec = (PBMParameterSpec)algorithmParameterSpec;
        this.params = new PBMParams(this.paramsSpec.getSalt(), this.paramsSpec.getOwfAlgorithmId(), this.paramsSpec.getIterationCount(), this.paramsSpec.getMacAlgorithmId());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.params = new PBMParams(byArray);
            this.paramsSpec = new PBMParameterSpec(this.params.salt, this.params.owf_id, this.params.iterationCount, this.params.mac_id);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "PBM Parameters";
    }

    protected class PBMParams
    extends Sequence {
        private byte[] salt;
        private int iterationCount;
        private AlgorithmId owf_id;
        private AlgorithmId mac_id;

        protected PBMParams(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            int n = 0;
            this.salt = ((OctetString)this.components.elementAt(n++)).getBytes();
            this.owf_id = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
            this.iterationCount = ((Integer)this.components.elementAt(n++)).getInt();
            System.err.println("Note! PBMParameters.PBMParams(byte[]) getting AlgorithmId has been commented out.");
        }

        protected PBMParams(byte[] byArray, AlgorithmId algorithmId, int n, AlgorithmId algorithmId2) {
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
                this.addComponent(new OctetString(byArray));
            } else {
                this.addComponent(new OctetString());
            }
            this.owf_id = algorithmId;
            this.addComponent(algorithmId);
            this.iterationCount = n;
            this.addComponent(new Integer(n));
            this.mac_id = algorithmId2;
            this.addComponent(algorithmId2);
        }
    }
}

