/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private RC2Params params;
    private RC2ParameterSpec paramsSpec;

    protected byte[] engineGetEncoded() throws IOException {
        return this.params.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.getName().equals("javax.crypto.spec.RC2ParameterSpec")) {
            throw new InvalidParameterSpecException(String.valueOf(clazz.getName()) + " not supported");
        }
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException("Not an RC2 param spec");
        }
        this.paramsSpec = (RC2ParameterSpec)algorithmParameterSpec;
        this.params = new RC2Params(this.paramsSpec.getEffectiveKeyBits(), this.paramsSpec.getIV());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.params = new RC2Params(byArray);
            this.paramsSpec = new RC2ParameterSpec(this.params.eKB, this.params.iv);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "RC2 Parameters";
    }

    protected class RC2Params
    extends Sequence {
        private int eKB;
        private int parameterVersion;
        private byte[] iv;

        protected RC2Params(int n, byte[] byArray) {
            this.eKB = n;
            this.parameterVersion = n == 40 ? 160 : (n == 64 ? 120 : 58);
            this.addComponent(new Integer(this.parameterVersion));
            this.iv = byArray;
            this.addComponent(new OctetString(byArray));
        }

        protected RC2Params(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.parameterVersion = ((Integer)this.components.elementAt(0)).getInt();
            this.eKB = this.parameterVersion == 160 ? 40 : (this.parameterVersion == 120 ? 64 : 128);
            this.iv = ((OctetString)this.components.elementAt(1)).getBytes();
        }
    }
}

