/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.RC4SecretKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RC4
extends CipherSpi {
    private short[] S = new short[256];
    private short x;
    private short y;

    private final byte[] encrypt(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.x = (short)RC4.modulo(this.x + 1, 256);
            this.y = (short)RC4.modulo(this.y + this.S[this.x], 256);
            this.swapByte(this.x, this.y);
            byArray2[n3] = (byte)(byArray[n3 + n] ^ this.S[RC4.modulo(this.S[this.x] + this.S[this.y], 256)]);
            ++n3;
        }
        return byArray2;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.encrypt(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.encrypt(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int n) {
        return n;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof RC4SecretKey)) {
            throw new InvalidKeyException("Not an RC4 Key");
        }
        byte[] byArray = key.getEncoded();
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < 256) {
            this.S[n3] = n3;
            n3 = (short)(n3 + 1);
        }
        short s = 0;
        int n4 = 0;
        short s2 = 0;
        while (s2 < 256) {
            s = (short)RC4.modulo(byArray[n4] + this.S[s2] + s, 256);
            this.swapByte(s2, s);
            n4 = (short)RC4.modulo(n4 + 1, n2);
            s2 = (short)(s2 + 1);
        }
        this.x = 0;
        this.y = 0;
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.encrypt(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        byte[] byArray3 = this.encrypt(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(RC4.modulo(-93, 256));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final int modulo(int n, int n2) {
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    private final void swapByte(short s, short s2) {
        short s3 = this.S[s];
        this.S[s] = this.S[s2];
        this.S[s2] = s3;
    }
}

