/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.RC4SecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public final class RC4SecretKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            if (!((SecretKeySpec)keySpec).getAlgorithm().equals("RC4")) {
                throw new InvalidKeySpecException("Not an RC4 key spec");
            }
            return new RC4SecretKey(((SecretKeySpec)keySpec).getEncoded());
        }
        throw new InvalidKeySpecException("Not an RC4 key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("No RC4-specific keyspec supported");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey instanceof SecretKeySpec) {
            return new RC4SecretKey(secretKey.getEncoded());
        }
        if (secretKey instanceof RC4SecretKey) {
            return new SecretKeySpec(secretKey.getEncoded(), "RC4");
        }
        throw new InvalidKeyException("Cannot translate this key");
    }
}

