/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.RC5SecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public final class RC5SecretKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            if (!((SecretKeySpec)keySpec).getAlgorithm().equals("RC5")) {
                throw new InvalidKeySpecException("Not an RC5 key spec");
            }
            return new RC5SecretKey(((SecretKeySpec)keySpec).getEncoded());
        }
        throw new InvalidKeySpecException("Not an RC5 key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("No RC5-specific keyspec supported");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey instanceof SecretKeySpec) {
            return new RC5SecretKey(secretKey.getEncoded());
        }
        if (secretKey instanceof RC5SecretKey) {
            return new SecretKeySpec(secretKey.getEncoded(), "RC5");
        }
        throw new InvalidKeyException("Cannot translate this key");
    }
}

