/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class RSA
extends CipherSpi {
    protected Key rsaKey;
    protected byte[] data;
    protected SecureRandom random;
    private int state;
    private ByteArrayOutputStream bos;
    private PKCS1Padding pad;
    private BigInteger modulus;
    private static final byte PRIVATE_KEY_ENCRYPT_MODE = 1;
    private static final byte PUBLIC_KEY_ENCRYPT_MODE = 2;
    private byte pkcs1Mode = (byte)2;

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        this.engineUpdate(byArray, n, n2);
        try {
            this.bos.flush();
            this.data = this.bos.toByteArray();
        }
        catch (IOException iOException) {}
        int n3 = (this.modulus.bitLength() + 1) / 8;
        if (this.state == 1) {
            byArray2 = this.pkcs1Mode == 2 ? this.publicKeyOp(this.pad.doPadding(n3, this.data)) : this.privateKeyOp(this.pad.doPadding(n3, this.data));
        } else if (this.state == 2) {
            byArray2 = this.pkcs1Mode == 2 ? this.pad.doUnPadding(n3, this.privateKeyOp(this.data)) : this.pad.doUnPadding(n3, this.publicKeyOp(this.data));
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.engineUpdate(byArray, n, n2);
        if (byArray2.length - n3 < this.engineGetOutputSize(n2)) {
            throw new ShortBufferException("Output Buffer too short");
        }
        byte[] byArray3 = new byte[]{};
        try {
            this.bos.flush();
            this.data = this.bos.toByteArray();
        }
        catch (IOException iOException) {}
        int n4 = (this.modulus.bitLength() + 1) / 8;
        if (this.state == 1) {
            byArray3 = this.pkcs1Mode == 2 ? this.publicKeyOp(this.pad.doPadding(n4, this.data)) : this.privateKeyOp(this.pad.doPadding(n4, this.data));
        } else if (this.state == 2) {
            byArray3 = this.pkcs1Mode == 2 ? this.pad.doUnPadding(n4, this.privateKeyOp(this.data)) : this.pad.doUnPadding(n4, this.publicKeyOp(this.data));
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int n) {
        return this.data.length + n;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = n;
        this.data = new byte[0];
        this.random = secureRandom;
        this.bos = new ByteArrayOutputStream();
        this.pad = new PKCS1Padding(this.pkcs1Mode);
        if (!key.getAlgorithm().equals("RSA")) {
            throw new InvalidKeyException("Not an RSA Key");
        }
        if (key instanceof PublicKey) {
            if (n == 2 && this.pkcs1Mode == 2) {
                throw new InvalidKeyException("Public Key decrypt not supported");
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "DSTC");
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key.getEncoded());
                this.rsaKey = keyFactory.generatePublic(x509EncodedKeySpec);
                this.modulus = ((RSAPublicKey)this.rsaKey).getModulus();
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Bad Key encoding");
            }
        } else if (key instanceof PrivateKey) {
            if (n == 2 && this.pkcs1Mode == 1) {
                throw new InvalidKeyException("Private Key decrypt not supported");
            }
            this.rsaKey = (RSAPrivateCrtKey)key;
            this.modulus = ((RSAPrivateCrtKey)this.rsaKey).getModulus();
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string.equals("1")) {
            this.pkcs1Mode = 1;
        } else if (string.equals("2")) {
            this.pkcs1Mode = (byte)2;
        } else {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " Not supported");
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equals("PKCS1Padding")) {
            throw new NoSuchPaddingException(String.valueOf(string) + " Not supported");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.bos.write(byArray, n, n2);
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.bos.write(byArray, n, n2);
        return 0;
    }

    private byte[] privateKeyOp(byte[] byArray) {
        BigInteger bigInteger = ((RSAPrivateCrtKey)this.rsaKey).getModulus();
        BigInteger bigInteger2 = ((RSAPrivateCrtKey)this.rsaKey).getPrivateExponent();
        BigInteger bigInteger3 = ((RSAPrivateCrtKey)this.rsaKey).getPrimeP();
        BigInteger bigInteger4 = ((RSAPrivateCrtKey)this.rsaKey).getPrimeQ();
        BigInteger bigInteger5 = ((RSAPrivateCrtKey)this.rsaKey).getPrimeExponentP();
        BigInteger bigInteger6 = ((RSAPrivateCrtKey)this.rsaKey).getPrimeExponentQ();
        BigInteger bigInteger7 = ((RSAPrivateCrtKey)this.rsaKey).getCrtCoefficient();
        BigInteger bigInteger8 = new BigInteger(1, byArray);
        BigInteger bigInteger9 = bigInteger8.modPow(bigInteger5, bigInteger3);
        BigInteger bigInteger10 = bigInteger8.modPow(bigInteger6, bigInteger4);
        BigInteger bigInteger11 = bigInteger9.subtract(bigInteger10).multiply(bigInteger7).mod(bigInteger3);
        BigInteger bigInteger12 = bigInteger11.multiply(bigInteger4).add(bigInteger10);
        return this.removeLeadingZero(bigInteger12.toByteArray());
    }

    private byte[] publicKeyOp(byte[] byArray) {
        BigInteger bigInteger = ((RSAPublicKey)this.rsaKey).getModulus();
        BigInteger bigInteger2 = ((RSAPublicKey)this.rsaKey).getPublicExponent();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return this.removeLeadingZero(bigInteger4.toByteArray());
    }

    private byte[] removeLeadingZero(byte[] byArray) {
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    protected class PKCS1Padding {
        private byte blockType;

        protected PKCS1Padding(byte by) {
            this.blockType = by;
        }

        protected byte[] doPadding(int n, byte[] byArray) {
            byte[] byArray2 = new byte[n];
            byArray2[0] = 0;
            byArray2[1] = this.blockType;
            if (this.blockType == 1 || this.blockType == 2) {
                int n2 = 0;
                while (n2 < n - 3 - byArray.length) {
                    byArray2[2 + n2] = -1;
                    ++n2;
                }
            } else {
                byte[] byArray3 = new byte[n - 3 - byArray.length];
                RSA.this.random.nextBytes(byArray3);
                int n3 = 0;
                while (n3 < byArray3.length) {
                    int n4 = n3++;
                    byArray3[n4] = (byte)(byArray3[n4] | 1);
                }
                System.arraycopy(byArray3, 0, byArray2, 2, byArray3.length);
            }
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
            return byArray2;
        }

        protected byte[] doUnPadding(int n, byte[] byArray) throws BadPaddingException {
            if (byArray[0] != this.blockType) {
                throw new BadPaddingException("Bad block type");
            }
            int n2 = 2 - n + byArray.length;
            while (byArray[n2] != 0) {
                ++n2;
            }
            byte[] byArray2 = new byte[byArray.length - n2 - 1];
            System.arraycopy(byArray, n2 + 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
    }
}

