/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.pkcs8.PKCS5KeyDerivation;
import com.dstc.security.pkcs8.PKCS8EncryptedPrivateKey;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPrivateKey;
import com.dstc.security.provider.RSAPublicKey;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ());
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
            return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return new RSAPrivateCrtKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidKeySpecException("Bad key spec");
            }
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                return new RSAPrivateCrtKey(privateKeyInfo.getEncodedKey());
            }
            catch (Exception exception) {
                try {
                    PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                    System.err.print("Enter password: ");
                    InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    PKCS5KeyDerivation pKCS5KeyDerivation = new PKCS5KeyDerivation();
                    pKCS8EncryptedPrivateKey.decrypt(bufferedReader.readLine(), pKCS5KeyDerivation);
                    return pKCS8EncryptedPrivateKey.getPrivateKey();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    throw new InvalidKeySpecException("Bad key spec: Wrong password?");
                }
            }
        }
        throw new InvalidKeySpecException("Cannot convert to RSA Private Key");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
                return new RSAPublicKey(subjectPublicKeyInfo.getEncodedKey());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidKeySpecException("Bad key spec");
            }
        }
        throw new InvalidKeySpecException("Cannot convert to RSA Public Key");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (!key.getAlgorithm().equals("RSA")) {
            throw new InvalidKeySpecException("Not an RSA Key");
        }
        if (clazz.getName().equals("java.security.spec.X509EncodedKeySpec")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (clazz.getName().equals("java.security.spec.RSAPublicKeySpec")) {
            return new RSAPublicKeySpec(((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent());
        }
        throw new InvalidKeySpecException("Cannot convert to this key spec");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Not yet supported");
    }
}

