/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private static BigInteger one = BigInteger.valueOf(1L);
    private static BigInteger two = BigInteger.valueOf(2L);
    private int modlen;
    private SecureRandom random;
    private static final int PROB = 10;

    public RSAKeyPairGenerator() {
        super("RSA");
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger = new BigInteger("10001", 16);
        BigInteger bigInteger2 = new BigInteger(this.modlen / 2, 10, this.random);
        BigInteger bigInteger3 = new BigInteger(this.modlen - this.modlen / 2, 10, this.random);
        BigInteger bigInteger4 = bigInteger2.subtract(one).multiply(bigInteger3.subtract(one));
        while (!bigInteger4.gcd(bigInteger).equals(one)) {
            bigInteger2 = bigInteger2.subtract(two);
            bigInteger3 = bigInteger3.subtract(two);
            bigInteger4 = bigInteger2.subtract(one).multiply(bigInteger3.subtract(one));
        }
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger.modInverse(bigInteger4);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger5, bigInteger);
        RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger5, bigInteger, bigInteger6, bigInteger2, bigInteger3);
        return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
    }

    public void initialize(int n) {
        this.modlen = n;
        this.random = new SecureRandom();
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.modlen = n;
        this.random = secureRandom;
    }
}

