/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.PrivateKey;

public class RSAPrivateKey
extends Sequence
implements PrivateKey,
java.security.interfaces.RSAPrivateKey {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger p;
    private BigInteger q;
    private static BigInteger one = BigInteger.valueOf(1L);

    protected RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
    }

    protected RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        this.addComponent(new Integer(BigInteger.valueOf(0L)));
        this.modulus = bigInteger;
        this.addComponent(new Integer(bigInteger));
        this.publicExponent = bigInteger2;
        this.addComponent(new Integer(bigInteger2));
        this.privateExponent = bigInteger3;
        this.addComponent(new Integer(bigInteger3));
        this.p = bigInteger4;
        this.addComponent(new Integer(bigInteger4));
        this.q = bigInteger5;
        this.addComponent(new Integer(bigInteger5));
        this.addComponent(new Integer(bigInteger3.mod(bigInteger4.subtract(one))));
        this.addComponent(new Integer(bigInteger3.mod(bigInteger5.subtract(one))));
        this.addComponent(new Integer(bigInteger5.modInverse(bigInteger4)));
    }

    protected RSAPrivateKey(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.modulus = ((Integer)this.components.elementAt(1)).getBigInteger();
        this.publicExponent = ((Integer)this.components.elementAt(2)).getBigInteger();
        this.privateExponent = ((Integer)this.components.elementAt(3)).getBigInteger();
        this.p = ((Integer)this.components.elementAt(4)).getBigInteger();
        this.q = ((Integer)this.components.elementAt(5)).getBigInteger();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            byte[] byArray = new PrivateKeyInfo(new AlgorithmId("1.2.840.113549.1.1.1", null), super.encode()).encode();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }
}

