/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.math.BigInteger;
import java.security.PublicKey;

public class RSAPublicKey
extends Sequence
implements PublicKey,
java.security.interfaces.RSAPublicKey {
    private BigInteger modulus;
    private BigInteger exponent;

    protected RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.exponent = bigInteger2;
        this.addComponent(new Integer(bigInteger));
        this.addComponent(new Integer(bigInteger2));
    }

    protected RSAPublicKey(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.modulus = ((Integer)this.components.elementAt(0)).getBigInteger();
        this.exponent = ((Integer)this.components.elementAt(1)).getBigInteger();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            return new SubjectPublicKeyInfo(new AlgorithmId("1.2.840.113549.1.1.1", null), super.encode()).encode();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }
}

