/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPublicKey;
import com.dstc.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;

public abstract class RSAwithAnyMD
extends SignatureSpi {
    protected RSAPublicKey pubKey;
    protected RSAPrivateCrtKey privKey;
    protected byte[] data;
    protected MessageDigest md;
    protected String mdOid;
    private DigestInfo digestInfo;
    private ByteArrayOutputStream bos;
    private Cipher rsa;

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.rsa = Cipher.getInstance("RSA/1/PKCS1Padding", "DSTC");
            this.rsa.init(1, privateKey);
            this.bos = new ByteArrayOutputStream();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.rsa = Cipher.getInstance("RSA/1/PKCS1Padding", "DSTC");
            this.rsa.init(2, publicKey);
            this.bos = new ByteArrayOutputStream();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.bos.toByteArray();
            if (byArray.length == 0) {
                throw new SignatureException("Nothing to sign");
            }
            byte[] byArray2 = this.mdOid != null ? new DigestInfo(this.mdOid, byArray).encode() : byArray;
            return this.rsa.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bos.write(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4 = this.bos.toByteArray();
            if (byArray4.length == 0) {
                throw new SignatureException("Nothing to verify");
            }
            byte[] byArray5 = this.rsa.doFinal(byArray);
            if (this.mdOid != null) {
                byArray3 = this.md.digest(byArray4);
                byArray2 = new DigestInfo(byArray5).getBytes();
            } else {
                byArray3 = byArray4;
                byArray2 = byArray5;
            }
            return Arrays.equals(byArray3, byArray2);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected class DigestInfo
    extends Sequence {
        private String oid;
        private byte[] bytes;

        protected DigestInfo(String string, byte[] byArray) throws Asn1Exception {
            this.oid = string;
            this.addComponent(new AlgorithmId(string, null));
            this.bytes = byArray;
            this.addComponent(new OctetString(RSAwithAnyMD.this.md.digest(byArray)));
        }

        protected DigestInfo(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.bytes = ((OctetString)this.components.elementAt(1)).getBytes();
        }

        protected byte[] getBytes() {
            return this.bytes;
        }
    }
}

