/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.DSAPrivateKey;
import com.dstc.security.provider.DSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;

public class RawDSA
extends SignatureSpi {
    private DSAPublicKey pubKey;
    private DSAPrivateKey privKey;
    private ByteArrayOutputStream bos;

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!privateKey.getAlgorithm().equals("DSA")) {
            throw new InvalidKeyException("Not a DSA Private Key");
        }
        this.privKey = (DSAPrivateKey)privateKey;
        this.bos = new ByteArrayOutputStream();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!publicKey.getAlgorithm().equals("DSA")) {
            throw new InvalidKeyException("Not a DSA Public Key");
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "DSTC");
            this.pubKey = (DSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(publicKey.getEncoded()));
            this.bos = new ByteArrayOutputStream();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.toString());
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            DSAParams dSAParams = this.privKey.getParams();
            BigInteger bigInteger = new BigInteger(dSAParams.getQ().bitLength() - 1, new Random());
            byte[] byArray = this.bos.toByteArray();
            if (byArray.length == 0) {
                throw new SignatureException("Nothing to sign");
            }
            System.out.println("data.length: " + byArray.length);
            BigInteger bigInteger2 = new BigInteger(1, byArray);
            BigInteger bigInteger3 = dSAParams.getG().modPow(bigInteger, dSAParams.getP()).mod(dSAParams.getQ());
            BigInteger bigInteger4 = bigInteger3.multiply(this.privKey.getX()).add(bigInteger2);
            BigInteger bigInteger5 = bigInteger.modInverse(dSAParams.getQ());
            BigInteger bigInteger6 = bigInteger5.multiply(bigInteger4).mod(dSAParams.getQ());
            return new DssSig(bigInteger3, bigInteger6).encode();
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bos.write(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            DssSig dssSig = new DssSig(byArray);
            BigInteger bigInteger = dssSig.r;
            BigInteger bigInteger2 = dssSig.s;
            DSAParams dSAParams = this.pubKey.getParams();
            BigInteger bigInteger3 = bigInteger2.modInverse(dSAParams.getQ());
            byte[] byArray2 = this.bos.toByteArray();
            if (byArray2.length == 0) {
                throw new SignatureException("Nothing to verify");
            }
            System.out.println("data.length: " + byArray2.length);
            BigInteger bigInteger4 = new BigInteger(1, byArray2);
            BigInteger bigInteger5 = bigInteger4.multiply(bigInteger3).mod(dSAParams.getQ());
            BigInteger bigInteger6 = bigInteger.multiply(bigInteger3).mod(dSAParams.getQ());
            BigInteger bigInteger7 = dSAParams.getG().modPow(bigInteger5, dSAParams.getP());
            BigInteger bigInteger8 = this.pubKey.getY().modPow(bigInteger6, dSAParams.getP());
            BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(dSAParams.getP()).mod(dSAParams.getQ());
            return bigInteger9.equals(bigInteger);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }

    protected class DssSig
    extends Sequence {
        private BigInteger r;
        private BigInteger s;

        protected DssSig(BigInteger bigInteger, BigInteger bigInteger2) {
            this.r = bigInteger;
            this.s = bigInteger2;
            this.addComponent(new Integer(bigInteger));
            this.addComponent(new Integer(bigInteger2));
        }

        protected DssSig(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.r = ((Integer)this.components.elementAt(0)).getBigInteger();
            this.s = ((Integer)this.components.elementAt(1)).getBigInteger();
        }
    }
}

