/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.security.MessageDigestSpi;

public final class SHA1
extends MessageDigestSpi
implements Cloneable {
    private static int blockSize = 64;
    private byte[] inputBuffer = new byte[blockSize];
    private int inputBufferOffset = 0;
    private int[] mdBuffer = new int[5];
    private int plainTextLength = 0;

    public SHA1() {
        this.mdBuffer[0] = 1732584193;
        this.mdBuffer[1] = -271733879;
        this.mdBuffer[2] = -1732584194;
        this.mdBuffer[3] = 271733878;
        this.mdBuffer[4] = -1009589776;
    }

    private static final int[] bytesToInts(byte[] byArray, int n, int n2) {
        int[] nArray = new int[(n2 + 3) / 4];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 / 4;
            nArray[n4] = nArray[n4] + ((byArray[n3 + n] & 0xFF) << 8 * ((3 - n3) % 4));
            ++n3;
        }
        return nArray;
    }

    public Object clone() throws CloneNotSupportedException {
        SHA1 sHA1 = new SHA1();
        sHA1.inputBufferOffset = this.inputBufferOffset;
        sHA1.plainTextLength = this.plainTextLength;
        System.arraycopy(this.mdBuffer, 0, sHA1.mdBuffer, 0, 5);
        System.arraycopy(this.inputBuffer, 0, sHA1.inputBuffer, 0, blockSize);
        return sHA1;
    }

    private static void doDecodeBlock(int[] nArray, int[] nArray2) {
        int[] nArray3 = SHA1.expandBlock(nArray2);
        int[] nArray4 = new int[5];
        System.arraycopy(nArray, 0, nArray4, 0, 5);
        int n = 0;
        while (n < 20) {
            SHA1.f1(nArray, nArray3, 0, 1, 2, 3, 4, n);
            ++n;
        }
        int n2 = 20;
        while (n2 < 40) {
            SHA1.f2(nArray, nArray3, 0, 1, 2, 3, 4, n2);
            ++n2;
        }
        int n3 = 40;
        while (n3 < 60) {
            SHA1.f3(nArray, nArray3, 0, 1, 2, 3, 4, n3);
            ++n3;
        }
        int n4 = 60;
        while (n4 < 80) {
            SHA1.f4(nArray, nArray3, 0, 1, 2, 3, 4, n4);
            ++n4;
        }
        int n5 = 0;
        while (n5 < 5) {
            int n6 = n5;
            nArray[n6] = nArray[n6] + nArray4[n5];
            ++n5;
        }
    }

    private final void doReset() {
        this.inputBufferOffset = 0;
        this.mdBuffer[0] = 1732584193;
        this.mdBuffer[1] = -271733879;
        this.mdBuffer[2] = -1732584194;
        this.mdBuffer[3] = 271733878;
        this.mdBuffer[4] = -1009589776;
        this.plainTextLength = 0;
    }

    protected byte[] engineDigest() {
        int n;
        int n2 = 56 - (this.plainTextLength & 0x3F);
        int n3 = n2 > 0 ? n2 : 64 + n2;
        this.inputBuffer[this.inputBufferOffset] = -128;
        int n4 = 1;
        if (this.inputBufferOffset + n3 > blockSize) {
            n4 = blockSize - this.inputBufferOffset;
            n = 1;
            while (n < n4) {
                this.inputBuffer[this.inputBufferOffset + n] = 0;
                ++n;
            }
            SHA1.doDecodeBlock(this.mdBuffer, SHA1.bytesToInts(this.inputBuffer, 0, blockSize));
            this.inputBufferOffset = -n4;
        }
        n = n4;
        while (n < n3) {
            this.inputBuffer[this.inputBufferOffset + n] = 0;
            ++n;
        }
        this.inputBufferOffset += n3;
        long l = this.plainTextLength * 8;
        int n5 = 0;
        while (n5 < 8) {
            this.inputBuffer[this.inputBufferOffset + n5] = (byte)(l >>> 8 * (7 - n5) & 0xFFL);
            ++n5;
        }
        SHA1.doDecodeBlock(this.mdBuffer, SHA1.bytesToInts(this.inputBuffer, 0, blockSize));
        byte[] byArray = SHA1.intsToBytes(this.mdBuffer);
        this.doReset();
        return byArray;
    }

    protected void engineReset() {
        this.doReset();
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2;
        int n5 = 0;
        while ((n3 = blockSize - this.inputBufferOffset) <= n4) {
            System.arraycopy(byArray, n5 + n, this.inputBuffer, this.inputBufferOffset, n3);
            SHA1.doDecodeBlock(this.mdBuffer, SHA1.bytesToInts(this.inputBuffer, 0, blockSize));
            n4 -= n3;
            this.inputBufferOffset = 0;
            n5 += n3;
        }
        System.arraycopy(byArray, n5 + n, this.inputBuffer, this.inputBufferOffset, n4);
        this.inputBufferOffset += n4;
        this.plainTextLength += n2;
    }

    private static int[] expandBlock(int[] nArray) {
        int[] nArray2 = new int[80];
        System.arraycopy(nArray, 0, nArray2, 0, 16);
        int n = 16;
        while (n < 80) {
            nArray2[n] = nArray2[n - 3] ^ nArray2[n - 8] ^ nArray2[n - 14] ^ nArray2[n - 16];
            nArray2[n] = nArray2[n] << 1 | nArray2[n] >>> 31;
            ++n;
        }
        return nArray2;
    }

    private static void f1(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (nArray[n] << 5 | nArray[n] >>> 27) + (nArray[n2] & nArray[n3] | ~nArray[n2] & nArray[n4]) + nArray[n5] + nArray2[n6] + 1518500249;
        nArray[n5] = nArray[n4];
        nArray[n4] = nArray[n3];
        nArray[n3] = nArray[n2] << 30 | nArray[n2] >>> 2;
        nArray[n2] = nArray[n];
        nArray[n] = n7;
    }

    private static void f2(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (nArray[n] << 5 | nArray[n] >>> 27) + (nArray[n2] ^ nArray[n3] ^ nArray[n4]) + nArray[n5] + nArray2[n6] + 1859775393;
        nArray[n5] = nArray[n4];
        nArray[n4] = nArray[n3];
        nArray[n3] = nArray[n2] << 30 | nArray[n2] >>> 2;
        nArray[n2] = nArray[n];
        nArray[n] = n7;
    }

    private static void f3(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (nArray[n] << 5 | nArray[n] >>> 27) + (nArray[n2] & nArray[n3] | nArray[n2] & nArray[n4] | nArray[n3] & nArray[n4]) + nArray[n5] + nArray2[n6] + -1894007588;
        nArray[n5] = nArray[n4];
        nArray[n4] = nArray[n3];
        nArray[n3] = nArray[n2] << 30 | nArray[n2] >>> 2;
        nArray[n2] = nArray[n];
        nArray[n] = n7;
    }

    private static void f4(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (nArray[n] << 5 | nArray[n] >>> 27) + (nArray[n2] ^ nArray[n3] ^ nArray[n4]) + nArray[n5] + nArray2[n6] + -899497514;
        nArray[n5] = nArray[n4];
        nArray[n4] = nArray[n3];
        nArray[n3] = nArray[n2] << 30 | nArray[n2] >>> 2;
        nArray[n2] = nArray[n];
        nArray[n] = n7;
    }

    private static final byte[] intsToBytes(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(nArray[n / 4] >>> 8 * ((3 - n) % 4) & 0xFF);
            ++n;
        }
        return byArray;
    }
}

