/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.SignedMessage;
import com.dstc.security.cms.Signer;
import com.dstc.security.cms.atts.ContentType;
import com.dstc.security.smime.SMIMEException;
import com.dstc.security.smime.TextCanonicalizer;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MimeMultipartSigned
extends MimeMultipart {
    private byte[] msg;
    private MimeBodyPart firstPart;
    private MimeBodyPart sigPart;
    private String digestAlgoName;
    private String sigAlgoName;
    private PrivateKey privateKey;
    private Set certificates;
    private X509Certificate signerCert;
    private SignedMessage signedMessage;

    public MimeMultipartSigned(DataSource dataSource) throws IOException, MessagingException {
        super(dataSource);
        this.firstPart = (MimeBodyPart)this.getBodyPart(0);
        this.sigPart = (MimeBodyPart)this.getBodyPart(1);
        if (!this.sigPart.isMimeType("application/x-pkcs7-signature")) {
            throw new MessagingException("Bad mime part");
        }
        this.signedMessage = (SignedMessage)this.sigPart.getDataHandler().getContent();
    }

    public MimeMultipartSigned(Multipart multipart) {
        super("signed; protocol=\"application/x-pkcs7-signature\"");
        try {
            this.firstPart = new MimeBodyPart();
            this.firstPart.setContent((Object)multipart, multipart.getContentType());
            this.firstPart.addHeader("Content-Type", multipart.getContentType());
            this.addBodyPart((BodyPart)this.firstPart);
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
    }

    public MimeMultipartSigned(MimeBodyPart mimeBodyPart) {
        super("signed; protocol=\"application/x-pkcs7-signature\"");
        try {
            this.firstPart = mimeBodyPart;
            this.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void debug(String string, byte[] byArray) {
        System.out.print(string);
        int n = 0;
        while (n < byArray.length) {
            System.out.print(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
            ++n;
        }
        System.out.println(" ");
    }

    public String getMessage() throws IOException, MessagingException {
        return (String)this.firstPart.getContent();
    }

    public Set getSignerCertificates() {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        Iterator iterator = this.signedMessage.getSigners().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((Signer)iterator.next()).getCertPath().getSignerCert());
        }
        return hashSet;
    }

    public void setCertificates(Set set) throws Asn1Exception, CertificateException {
        this.certificates = set;
    }

    public void setDigestAlgorithm(String string) {
        this.digestAlgoName = string;
        try {
            if (string.equals("SHA-1")) {
                this.setSubType("signed; micalg=sha1");
            } else if (string.equals("MD5")) {
                this.setSubType("signed; micalg=md5");
            }
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
    }

    public void setKeys(PrivateKey privateKey, X509Certificate x509Certificate) {
        this.privateKey = privateKey;
        this.signerCert = x509Certificate;
    }

    public void setSignatureAlgorithm(String string) {
        this.sigAlgoName = string;
    }

    public void setTrustedCAs(Set set) {
        this.signedMessage.setTrustedCAs(set);
    }

    public void sign() throws SMIMEException {
        if (this.sigAlgoName == null) {
            throw new SMIMEException("Signature algorithm not yet set");
        }
        if (this.digestAlgoName == null) {
            throw new SMIMEException("Digest algorithm not yet set");
        }
        if (this.privateKey == null) {
            throw new SMIMEException("Private Key not yet set");
        }
        try {
            TextCanonicalizer textCanonicalizer = new TextCanonicalizer(this.firstPart);
            this.msg = textCanonicalizer.getDigest();
            HashSet<ContentType> hashSet = new HashSet<ContentType>();
            ContentType contentType = new ContentType("1.2.840.113549.1.7.1");
            hashSet.add(contentType);
            Signer signer = new Signer(this.signerCert, this.certificates, this.privateKey);
            signer.setDigestAlgorithm(this.digestAlgoName);
            signer.setSignatureAlgorithm(this.sigAlgoName);
            signer.setSignedAttributes(hashSet);
            this.signedMessage = new SignedMessage(signer, this.msg);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)this.signedMessage, "application/x-pkcs7-signature");
            mimeBodyPart.addHeader("Content-Type", "application/x-pkcs7-signature; name=\"smime.p7s\"");
            mimeBodyPart.addHeader("Content-Transfer-Encoding", "base64");
            mimeBodyPart.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            mimeBodyPart.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            this.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void verify() throws SMIMEException {
        try {
            Object object;
            String string = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this.getContentType(), ";");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (!((String)object).startsWith("micalg")) continue;
                if (((String)object).equals("micalg=sha1")) {
                    string = "SHA-1";
                    break;
                }
                if (((String)object).equals("micalg=md5")) {
                    string = "MD5";
                    break;
                }
                throw new SMIMEException("Unknown micalg");
            }
            object = new TextCanonicalizer(this.firstPart);
            this.msg = ((TextCanonicalizer)object).getDigest();
            HashSet hashSet = new HashSet();
            this.signedMessage.verify(this.msg);
        }
        catch (Exception exception) {
            throw new SMIMEException(exception.getMessage());
        }
    }
}

