/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.EnvelopedMessage;
import com.dstc.security.cms.Recipient;
import com.dstc.security.smime.SMIMEException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;

public class SMIMEPart
extends MimeBodyPart {
    private static final String CONTENT_TYPE = "application/x-pkcs7-mime";
    private static final String CONTENT_TRANSFER_ENCODING = "base64";
    private static final String CONTENT_DISPOSITION = "attachment; filename=\"smime.p7m\"";
    private static final String CONTENT_DESCRIPTION = "S/MIME Encrypted Message";
    private EnvelopedMessage envelopedMessage = null;
    private SecureRandom rand = null;

    public SMIMEPart() {
    }

    public SMIMEPart(Multipart multipart, SecureRandom secureRandom) {
        try {
            this.rand = secureRandom;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)multipart, multipart.getContentType());
            mimeBodyPart.addHeader("Content-Type", multipart.getContentType());
            mimeBodyPart.addHeader("Content-Transfer-Encoding", "7bit");
            this.initialize(mimeBodyPart);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SMIMEPart(MimeBodyPart mimeBodyPart, SecureRandom secureRandom) {
        this.rand = secureRandom;
        this.initialize(mimeBodyPart);
    }

    public void addRecipient(X509Certificate x509Certificate) throws SMIMEException {
        try {
            this.envelopedMessage.addRecipient(new Recipient(x509Certificate));
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage());
        }
    }

    public void decrypt(X509Certificate x509Certificate, PrivateKey privateKey) throws SMIMEException {
        try {
            this.envelopedMessage.decrypt(x509Certificate, privateKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMIMEException(exception.getMessage());
        }
    }

    public void encrypt() throws SMIMEException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            super.writeTo((OutputStream)byteArrayOutputStream);
            this.envelopedMessage.setMessage(byteArrayOutputStream.toByteArray());
            this.envelopedMessage.encrypt();
            super.setContent((Object)this.envelopedMessage, CONTENT_TYPE);
            this.setHeader("Content-Type", CONTENT_TYPE);
            this.setHeader("Content-Transfer-Encoding", CONTENT_TRANSFER_ENCODING);
            this.setHeader("Content-Disposition", CONTENT_DISPOSITION);
            this.setHeader("Content-Description", CONTENT_DESCRIPTION);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMIMEException(exception.toString());
        }
    }

    public byte[] getDecrypted() throws SMIMEException {
        try {
            return this.envelopedMessage.getMessage();
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage());
        }
    }

    public Set getOriginatorCerts() {
        return this.envelopedMessage.getOriginatorCerts();
    }

    public void initialize(MimeBodyPart mimeBodyPart) {
        try {
            this.envelopedMessage = new EnvelopedMessage(this.rand);
            this.setContent(mimeBodyPart.getContent(), mimeBodyPart.getContentType());
            this.setHeader("Content-Type", mimeBodyPart.getContentType());
            this.setHeader("Content-Transfer-Encoding", mimeBodyPart.getEncoding());
            this.setDisposition(mimeBodyPart.getDisposition());
            this.setDescription(mimeBodyPart.getDescription());
            if (mimeBodyPart.getFileName() != null) {
                this.setFileName(mimeBodyPart.getFileName());
            }
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setContent(Object object, String string) throws MessagingException {
        if (object instanceof EnvelopedMessage && string.startsWith(CONTENT_TYPE)) {
            this.envelopedMessage = (EnvelopedMessage)object;
        }
        super.setContent(object, string);
    }

    public void setEncryptionAlgorithm(String string) throws SMIMEException {
        if (string == null) {
            throw new SMIMEException("Algorithm not set");
        }
        try {
            this.envelopedMessage.setEncryptionAlgorithm(string);
        }
        catch (CMSException cMSException) {
            cMSException.printStackTrace();
            throw new SMIMEException(cMSException.getMessage());
        }
    }
}

