/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.smime.Transformer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

public class SecMail {
    public static MimeMessage composeMessage() {
        try {
            String string;
            System.out.println("\nCompose message now, finishing off with a . on a separate line\n");
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance(null, null));
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            System.err.print("From: ");
            String string2 = bufferedReader.readLine();
            System.err.print("To: ");
            String string3 = bufferedReader.readLine();
            System.err.print("Subject: ");
            String string4 = bufferedReader.readLine();
            StringBuffer stringBuffer = new StringBuffer();
            while (!(string = bufferedReader.readLine()).equals(".")) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            byte[] byArray = stringBuffer.toString().getBytes();
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.addHeader("Content-Type", "text/plain; charset=us-ascii");
            internetHeaders.addHeader("Content-Transfer-Encoding", "7bit");
            MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byArray);
            mimeMessage.setContent(mimeBodyPart.getContent(), "text/plain");
            mimeMessage.setHeader("Content-Type", "text/plain; charset=us-ascii");
            mimeMessage.setHeader("Content-Transfer-Encoding", "7bit");
            mimeMessage.setFrom((Address)new InternetAddress(string2));
            InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string3)};
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
            mimeMessage.setSubject(string4);
            mimeMessage.setSentDate(new Date());
            return mimeMessage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 0) {
            SecMail.transform(stringArray);
            return;
        }
        try {
            Transformer transformer = new Transformer();
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (true) {
                Object object;
                System.err.print("\n(C)ompose or (D)ecode an S/MIME message, (S)etup or (Q)uit? ");
                String string = bufferedReader.readLine();
                if (string.equalsIgnoreCase("Q")) {
                    transformer.saveReceiverCerts();
                    transformer.saveTrustedCerts();
                    return;
                }
                if (string.equalsIgnoreCase("C")) {
                    object = SecMail.composeMessage();
                    System.err.print("\n(E)ncrypt, (S)ign or Sign (A)nd Encrypt the message? ");
                    string = bufferedReader.readLine();
                    if (string.equalsIgnoreCase("E")) {
                        object = Transformer.encrypt((MimeMessage)object);
                    } else if (string.equalsIgnoreCase("S")) {
                        object = Transformer.sign((MimeMessage)object);
                    } else {
                        if (!string.equalsIgnoreCase("A")) break;
                        object = Transformer.sign((MimeMessage)object);
                        object = Transformer.encrypt((MimeMessage)object);
                    }
                    System.err.print("\n(S)end if off or (O)utput to a file? ");
                    string = bufferedReader.readLine();
                    if (string.equalsIgnoreCase("S")) {
                        Transport.send((Message)object);
                        continue;
                    }
                    System.err.print("\nEnter file name: ");
                    object.writeTo((OutputStream)new FileOutputStream(bufferedReader.readLine()));
                    continue;
                }
                if (string.equalsIgnoreCase("D")) {
                    System.err.print("\nFile to decode? ");
                    string = bufferedReader.readLine();
                    object = new FileInputStream(string);
                    MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance(null, null), (InputStream)object);
                    ((FileInputStream)object).close();
                    mimeMessage = Transformer.decode(mimeMessage);
                    if (mimeMessage.getContentType().startsWith("text/plain")) {
                        System.out.println("");
                        mimeMessage.writeTo((OutputStream)System.out);
                        System.out.println("");
                        continue;
                    }
                    System.err.print("\nFile to save message? ");
                    string = bufferedReader.readLine();
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    mimeMessage.writeTo((OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    continue;
                }
                if (!string.equalsIgnoreCase("S")) continue;
                System.err.print("\nEnter trusted cert to add: ");
                string = bufferedReader.readLine();
                object = new FileInputStream(string);
                transformer.addTrustedCert((InputStream)object);
                transformer.saveTrustedCerts();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printUsage() {
        StringBuffer stringBuffer = new StringBuffer("Usage: ");
        stringBuffer.append("java com.dstc.security.smime.SecMail ");
        stringBuffer.append("[-d | -e | -s] <in file> <out file>\n\n");
        stringBuffer.append("where:\n");
        stringBuffer.append("  -d    Decodes input message\n");
        stringBuffer.append("  -e    Encrypts input message\n");
        stringBuffer.append("  -s    Signs input message\n\n");
        stringBuffer.append("If <out file> is unspecified output will be sent to stdout\n");
        stringBuffer.append("If no parameters are passed interactive mode is entered\n");
        System.out.println(stringBuffer.toString());
    }

    public static void transform(String[] stringArray) {
        try {
            switch (stringArray.length) {
                case 2: {
                    if (stringArray[0].equals("-d")) {
                        Transformer.decode(new FileInputStream(stringArray[1]), System.out);
                        break;
                    }
                    if (stringArray[0].equals("-e")) {
                        Transformer.encrypt(new FileInputStream(stringArray[1]), System.out);
                        break;
                    }
                    if (stringArray[0].equals("-s")) {
                        Transformer.sign(new FileInputStream(stringArray[1]), System.out);
                    }
                    break;
                }
                case 3: {
                    if (stringArray[0].equals("-d")) {
                        Transformer.decode(new FileInputStream(stringArray[1]), new FileOutputStream(stringArray[2]));
                        break;
                    }
                    if (stringArray[0].equals("-e")) {
                        Transformer.encrypt(new FileInputStream(stringArray[1]), new FileOutputStream(stringArray[2]));
                        break;
                    }
                    if (stringArray[0].equals("-s")) {
                        Transformer.sign(new FileInputStream(stringArray[1]), new FileOutputStream(stringArray[2]));
                    }
                    break;
                }
                default: {
                    SecMail.printUsage();
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

