/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.cms.EnvelopedMessage;
import com.dstc.security.smime.MimeMultipartSigned;
import com.dstc.security.smime.SMIMEPart;
import com.dstc.security.util.Config;
import com.dstc.security.x509.Base64OutputStream;
import com.dstc.security.x509.ExtensionFactory;
import com.dstc.security.x509.extns.SubjectAltName;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Transformer {
    private static final String SMIME_CONF = "jcsi.smime.conf";
    private static final String SMIME_PROPERTIES = "smime.properties";
    private static final int FORWARD_MODE = 0;
    private static final int REVERSE_MODE = 1;
    private Session session;
    private MimeMessage msg;
    private String sender;
    private String to;
    private String subject;
    private int mode;
    private boolean debug = true;
    private MimeBodyPart currentPart;
    private MimeMultipart currentMultipart;
    private PrivateKey myPriv = null;
    private CertificateFactory certFact;
    private String sigAlgName;
    private X509Certificate myCert = null;
    private Set trustedCerts = null;
    private Hashtable receiverCertTable = null;
    private Set myCerts = null;
    private Properties props;
    private String keyDir = null;
    private SecureRandom rand = new SecureRandom(new byte[8]);

    public Transformer() throws ToolException {
        try {
            this.props = Config.getProperties(SMIME_CONF, SMIME_PROPERTIES);
            this.keyDir = (String)((Hashtable)this.props).get("jcsi.smime.key.dir");
            this.sender = (String)((Hashtable)this.props).get("jcsi.smime.sender");
            this.setupMailcap();
            this.session = Session.getDefaultInstance((Properties)this.props, null);
            this.session.setDebug(this.debug);
            this.certFact = CertificateFactory.getInstance("X509");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void addToReceiverCertTable(X509Certificate x509Certificate) throws ToolException {
        if (!x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
            return;
        }
        SubjectAltName subjectAltName = (SubjectAltName)ExtensionFactory.getExtension("2.5.29.17", x509Certificate);
        if (subjectAltName != null) {
            this.receiverCertTable.put(subjectAltName.getName(), x509Certificate);
            return;
        }
        String string = x509Certificate.getSubjectDN().getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.startsWith("email")) continue;
            this.receiverCertTable.put(string2.substring(6), x509Certificate);
            break;
        }
    }

    public void addTrustedCert(InputStream inputStream) throws ToolException {
        try {
            if (this.trustedCerts == null) {
                this.loadTrustedCerts();
            }
            X509Certificate x509Certificate = (X509Certificate)this.certFact.generateCertificate(inputStream);
            this.trustedCerts.add(x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) {
        try {
            Transformer transformer = new Transformer();
            transformer.decodeMessage(inputStream);
            transformer.save(outputStream);
            transformer.saveReceiverCerts();
            transformer.saveTrustedCerts();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static MimeMessage decode(MimeMessage mimeMessage) {
        try {
            Transformer transformer = new Transformer();
            transformer.decodeMessage(mimeMessage);
            transformer.save(null);
            transformer.saveReceiverCerts();
            transformer.saveTrustedCerts();
            return transformer.getMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void decodeMessage(InputStream inputStream) throws ToolException {
        try {
            this.decodeMessage(new MimeMessage(this.session, inputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void decodeMessage(MimeMessage mimeMessage) throws ToolException {
        try {
            this.msg = mimeMessage;
            this.mode = 1;
            this.currentMultipart = null;
            this.currentPart = null;
            do {
                if (mimeMessage.getContentType().startsWith("multipart/signed")) {
                    this.verifySignedMessage();
                    continue;
                }
                if (!mimeMessage.getContentType().startsWith("application/x-pkcs7-mime")) break;
                this.decryptEncryptedMessage();
            } while (!(this.currentPart == null & this.currentMultipart == null));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void decryptEncryptedMessage() throws ToolException {
        try {
            if (this.myPriv == null) {
                this.loadPrivateKeyAndCert();
            }
            this.currentPart = new SMIMEPart();
            this.currentPart.setContent(this.msg.getContent(), this.msg.getContentType());
            ((SMIMEPart)this.currentPart).decrypt(this.myCert, this.myPriv);
            byte[] byArray = ((SMIMEPart)this.currentPart).getDecrypted();
            this.msg.removeHeader("Content-Type");
            this.msg.removeHeader("Content-Transfer-Encoding");
            this.msg.removeHeader("Content-Description");
            this.msg.removeHeader("Content-Disposition");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InternetHeaders internetHeaders = new InternetHeaders((InputStream)byteArrayInputStream);
            byte[] byArray2 = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(byArray2);
            MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byArray2);
            this.msg.setContent(mimeBodyPart.getContent(), mimeBodyPart.getContentType());
            Set set = ((SMIMEPart)this.currentPart).getOriginatorCerts();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    System.out.println(((X509Certificate)iterator.next()).toString());
                }
            }
            this.updateMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void encrypt() throws ToolException {
        String string = this.props.getProperty("jcsi.smime.encryptionAlg");
        if (string == null) {
            throw new ToolException("Encryption algorithm unspecified");
        }
        try {
            this.mode = 0;
            if (this.receiverCertTable == null) {
                this.setupReceiverCertTable();
            }
            SMIMEPart sMIMEPart = null;
            if (this.currentMultipart != null) {
                sMIMEPart = new SMIMEPart((Multipart)this.currentMultipart, this.rand);
            } else if (this.currentPart != null) {
                sMIMEPart = new SMIMEPart(this.currentPart, this.rand);
            }
            sMIMEPart.setEncryptionAlgorithm(string);
            X509Certificate x509Certificate = (X509Certificate)this.receiverCertTable.get(this.to);
            if (x509Certificate == null) {
                System.err.println("\nCannot find certificate for receiver");
                System.err.print("Enter filename for receiver certificate: ");
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                FileInputStream fileInputStream = new FileInputStream(bufferedReader.readLine());
                x509Certificate = (X509Certificate)this.certFact.generateCertificate(fileInputStream);
                this.addToReceiverCertTable(x509Certificate);
            }
            sMIMEPart.addRecipient(x509Certificate);
            sMIMEPart.encrypt();
            this.currentPart = sMIMEPart;
            this.msg.setContent(this.currentPart.getContent(), "application/x-pkcs7-mime; name=\"smime.p7m\"");
            this.msg.setHeader("Content-Transfer-Encoding", "base64");
            this.msg.setHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            this.msg.setHeader("Content-Description", "S/MIME Encrypted Message");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public static void encrypt(InputStream inputStream, OutputStream outputStream) {
        try {
            Transformer transformer = new Transformer();
            transformer.setMessage(inputStream);
            transformer.encrypt();
            transformer.save(outputStream);
            transformer.saveReceiverCerts();
            transformer.saveTrustedCerts();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static MimeMessage encrypt(MimeMessage mimeMessage) {
        try {
            Transformer transformer = new Transformer();
            transformer.setMessage(mimeMessage);
            transformer.encrypt();
            transformer.save(null);
            transformer.saveReceiverCerts();
            transformer.saveTrustedCerts();
            return transformer.getMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private MimeMessage getMessage() {
        return this.msg;
    }

    public String getSender() {
        return this.sender;
    }

    public void loadPrivateKeyAndCert() throws ToolException {
        try {
            KeyFactory keyFactory;
            if (this.mode == 0) {
                if (this.sigAlgName == null) {
                    throw new ToolException("Signature algorithm not yet set");
                }
                keyFactory = this.sigAlgName.equals("SHA-1/DSA") ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("RSA");
            } else {
                keyFactory = KeyFactory.getInstance("RSA");
            }
            String string = this.props.getProperty("jcsi.smime.privKey");
            if (string == null) {
                throw new ToolException("Location of private key file unspecified");
            }
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + "/" + string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            System.err.println("Enter password to unlock private key");
            this.myPriv = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            string = this.props.getProperty("jcsi.smime.myCert");
            if (string == null) {
                throw new ToolException("Location of user certificate unspecified");
            }
            fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + "/" + string);
            this.myCert = (X509Certificate)this.certFact.generateCertificate(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void loadTrustedCerts() throws ToolException {
        try {
            String string = this.props.getProperty("jcsi.smime.trustedCerts");
            if (string == null) {
                throw new ToolException("Location of trusted certs unspecified");
            }
            File file = new File(String.valueOf(this.keyDir) + "/" + string);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.trustedCerts = new HashSet();
            while (byteArrayInputStream.available() > 0) {
                X509Certificate x509Certificate = (X509Certificate)this.certFact.generateCertificate(byteArrayInputStream);
                this.trustedCerts.add(x509Certificate);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void save(OutputStream outputStream) throws MessagingException, IOException {
        this.msg.saveChanges();
        if (outputStream != null) {
            this.msg.writeTo(outputStream);
        }
    }

    public void saveReceiverCerts() throws ToolException {
        if (this.receiverCertTable == null || this.receiverCertTable.isEmpty()) {
            return;
        }
        try {
            Iterator iterator = this.receiverCertTable.values().iterator();
            File file = new File(String.valueOf(this.keyDir) + "/" + this.props.getProperty("jcsi.smime.receiverCerts"));
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(0L);
            while (iterator.hasNext()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
                base64OutputStream.write(((X509Certificate)iterator.next()).getEncoded());
                base64OutputStream.flush();
                randomAccessFile.write(byteArrayOutputStream.toByteArray());
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void saveTrustedCerts() throws ToolException {
        if (this.trustedCerts == null) {
            return;
        }
        try {
            Iterator iterator = this.trustedCerts.iterator();
            File file = new File(String.valueOf(this.keyDir) + "/" + this.props.getProperty("jcsi.smime.trustedCerts"));
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(0L);
            while (iterator.hasNext()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
                base64OutputStream.write(((X509Certificate)iterator.next()).getEncoded());
                base64OutputStream.flush();
                randomAccessFile.write(byteArrayOutputStream.toByteArray());
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void setMessage(InputStream inputStream) throws ToolException {
        try {
            this.setMessage(new MimeMessage(this.session, inputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void setMessage(MimeMessage mimeMessage) throws ToolException {
        try {
            this.msg = mimeMessage;
            Address[] addressArray = mimeMessage.getRecipients(Message.RecipientType.TO);
            this.to = addressArray[0].toString();
            if (mimeMessage.getContentType().startsWith("multipart")) {
                this.currentMultipart = (MimeMultipart)mimeMessage.getContent();
                this.currentPart = null;
            } else {
                this.currentMultipart = null;
                this.currentPart = new MimeBodyPart();
                this.currentPart.setContent(mimeMessage.getContent(), mimeMessage.getContentType());
                this.currentPart.setHeader("Content-Type", mimeMessage.getContentType());
                this.currentPart.setHeader("Content-Transfer-Encoding", mimeMessage.getEncoding());
                this.currentPart.setDisposition(mimeMessage.getDisposition());
                this.currentPart.setDescription(mimeMessage.getDescription());
            }
            mimeMessage.setDisposition(null);
            mimeMessage.setDescription(null);
            mimeMessage.removeHeader("Content-Type");
            mimeMessage.removeHeader("Content-Transfer-Encoding");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void setupMailcap() {
        MailcapCommandMap mailcapCommandMap = new MailcapCommandMap();
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;;  x-java-content-handler=com.dstc.security.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("multipart/signed;;  x-java-content-handler=com.dstc.security.smime.handlers.multipart_signed");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;;  x-java-content-handler=com.dstc.security.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }

    public void setupReceiverCertTable() throws ToolException {
        try {
            Object object;
            this.receiverCertTable = new Hashtable();
            HashSet<Object> hashSet = new HashSet<Object>();
            String string = this.props.getProperty("jcsi.smime.receiverCerts");
            if (string == null) {
                return;
            }
            File file = new File(String.valueOf(this.keyDir) + "/" + string);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            while (byteArrayInputStream.available() > 0) {
                object = (X509Certificate)this.certFact.generateCertificate(byteArrayInputStream);
                hashSet.add(object);
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)object.next();
                this.addToReceiverCertTable(x509Certificate);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void sign() throws ToolException {
        this.sigAlgName = this.props.getProperty("jcsi.smime.signatureAlg");
        if (this.sigAlgName == null) {
            throw new ToolException("Signature algorithm unspecified");
        }
        try {
            this.mode = 0;
            MimeMultipartSigned mimeMultipartSigned = this.currentPart != null ? new MimeMultipartSigned(this.currentPart) : new MimeMultipartSigned((Multipart)this.currentMultipart);
            mimeMultipartSigned.setSignatureAlgorithm(this.sigAlgName);
            mimeMultipartSigned.setDigestAlgorithm("SHA-1");
            if (this.myPriv == null || this.myCert == null) {
                this.loadPrivateKeyAndCert();
            }
            if (this.myCerts == null) {
                this.myCerts = new HashSet();
                this.myCerts.add(this.myCert);
                String string = this.props.getProperty("jcsi.smime.caCert");
                if (string != null) {
                    FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + "/" + string);
                    this.myCerts.add((X509Certificate)this.certFact.generateCertificate(fileInputStream));
                    fileInputStream.close();
                }
            }
            mimeMultipartSigned.setKeys(this.myPriv, this.myCert);
            mimeMultipartSigned.setCertificates(this.myCerts);
            mimeMultipartSigned.sign();
            this.currentMultipart = mimeMultipartSigned;
            this.msg.setContent((Multipart)this.currentMultipart);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public static void sign(InputStream inputStream, OutputStream outputStream) {
        try {
            Transformer transformer = new Transformer();
            transformer.setMessage(inputStream);
            transformer.sign();
            transformer.save(outputStream);
            transformer.saveReceiverCerts();
            transformer.saveTrustedCerts();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static MimeMessage sign(MimeMessage mimeMessage) {
        try {
            Transformer transformer = new Transformer();
            transformer.setMessage(mimeMessage);
            transformer.sign();
            transformer.save(null);
            transformer.saveReceiverCerts();
            transformer.saveTrustedCerts();
            return transformer.getMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void updateMessage() throws MessagingException, IOException {
        this.msg.saveChanges();
        Object object = this.msg.getContent();
        if (object instanceof EnvelopedMessage) {
            this.currentPart = new SMIMEPart();
            this.currentPart.setContent(object, this.msg.getContentType());
        } else if (object instanceof MimeMultipartSigned) {
            this.currentMultipart = (MimeMultipartSigned)((Object)object);
            this.currentPart = null;
        } else {
            this.currentPart = null;
        }
    }

    public void verifySignedMessage() throws ToolException {
        try {
            if (this.trustedCerts == null) {
                this.loadTrustedCerts();
            }
            this.currentMultipart = (MimeMultipartSigned)((Object)this.msg.getContent());
            ((MimeMultipartSigned)this.currentMultipart).setTrustedCAs(this.trustedCerts);
            ((MimeMultipartSigned)this.currentMultipart).verify();
            this.currentPart = (MimeBodyPart)this.currentMultipart.getBodyPart(0);
            this.msg.setContent(this.currentPart.getContent(), this.currentPart.getContentType());
            if (this.receiverCertTable == null) {
                this.setupReceiverCertTable();
            }
            Iterator iterator = ((MimeMultipartSigned)this.currentMultipart).getSignerCertificates().iterator();
            while (iterator.hasNext()) {
                this.addToReceiverCertTable((X509Certificate)iterator.next());
            }
            this.updateMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    protected class ToolException
    extends Exception {
        protected ToolException(String string) {
            super(string);
        }
    }
}

