/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.V3Message;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

final class Alert
extends V3Message {
    protected static final byte CLOSE_NOTIFY = 0;
    protected static final byte UNEXPECTED_MESSAGE = 10;
    protected static final byte BAD_RECORD_MAC = 20;
    protected static final byte DECOMPRESSION_FAILURE = 30;
    protected static final byte HANDSHAKE_FAILURE = 40;
    protected static final byte NO_CERTIFICATE = 41;
    protected static final byte BAD_CERTIFICATE = 42;
    protected static final byte UNSUPPORTED_CERTIFICATE = 43;
    protected static final byte CERTIFICATE_REVOKED = 44;
    protected static final byte CERTIFICATE_EXPIRED = 45;
    protected static final byte CERTIFICATE_UNKNOWN = 46;
    protected static final byte ILLEGAL_PARAMETER = 47;
    protected static final byte WARNING = 1;
    protected static final byte FATAL = 2;
    private byte level;
    private byte description;

    protected Alert() {
        this.length = 2;
        this.contentType = (byte)21;
    }

    protected Alert(byte by, byte by2) {
        this();
        this.level = by;
        this.description = by2;
    }

    protected Alert(byte[] byArray) throws IOException {
        this();
        XDRInputStream xDRInputStream = new XDRInputStream(new ByteArrayInputStream(byArray));
        this.level = xDRInputStream.readByte();
        this.description = xDRInputStream.readByte();
        if (Debug.debug >= 1) {
            Debug.debug("  **** Alert ****");
            Debug.debug("level: " + this.level);
            Debug.debug("description: " + this.description);
        }
    }

    protected void write(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.writeByte(this.level);
        xDROutputStream.writeByte(this.description);
    }
}

