/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.SSLServerSocket;
import com.dstc.security.ssl.SessionCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Vector;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLServerSocketFactory;

public abstract class BaseSSLServerSocketFactory
extends SSLServerSocketFactory {
    protected static BaseSSLServerSocketFactory instance = null;
    private SecureRandom rand = new SecureRandom(new byte[8]);
    private Vector trustedCerts = null;
    private SessionCache cache = new SessionCache();
    private PrivateKey privKey = null;
    private Vector serverCerts = null;
    private String[] enabledCipherSuites = null;
    private boolean clientAuthRequired = false;

    protected BaseSSLServerSocketFactory() throws SSLKeyException {
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return new SSLServerSocket(this, n, this.privKey, this.serverCerts, this.clientAuthRequired, this.enabledCipherSuites);
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        return new SSLServerSocket(this, n, n2, this.privKey, this.serverCerts, this.clientAuthRequired, this.enabledCipherSuites);
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return new SSLServerSocket(this, n, n2, inetAddress, this.privKey, this.serverCerts, this.clientAuthRequired, this.enabledCipherSuites);
    }

    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    SecureRandom getRandom() {
        return this.rand;
    }

    SessionCache getSessionCache() {
        return this.cache;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    Vector getTrustedCertificates() {
        return this.trustedCerts;
    }

    protected void initializeKeys() throws SSLKeyException {
    }

    public void setClientAuthRequired(boolean bl) {
        this.clientAuthRequired = bl;
    }

    public void setDefaultCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public void setServerCertificates(Vector vector) {
        this.serverCerts = vector;
    }

    public void setServerPrivateKey(PrivateKey privateKey) {
        this.privKey = privateKey;
    }

    public void setTrustedCertificates(Vector vector) {
        this.trustedCerts = vector;
    }
}

