/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.SessionCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Vector;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLSocketFactory;

public abstract class BaseSSLSocketFactory
extends SSLSocketFactory {
    protected static BaseSSLSocketFactory instance = null;
    private SecureRandom rand = new SecureRandom(new byte[8]);
    private Vector trustedCerts = null;
    private SessionCache cache = new SessionCache();
    private PrivateKey privKey = null;
    private Vector clientCerts = null;
    private String[] enabledCipherSuites = null;

    protected BaseSSLSocketFactory() throws SSLKeyException {
    }

    public Socket createSocket(String string, int n) throws IOException {
        return new SSLSocket(string, n, this.privKey, this.clientCerts, this.enabledCipherSuites, this.trustedCerts, this.cache, this.rand);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return new SSLSocket(string, n, inetAddress, n2, this.privKey, this.clientCerts, this.enabledCipherSuites, this.trustedCerts, this.cache, this.rand);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException, UnknownHostException {
        return new SSLSocket(inetAddress, n, this.privKey, this.clientCerts, this.enabledCipherSuites, this.trustedCerts, this.cache, this.rand);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException, UnknownHostException {
        return new SSLSocket(inetAddress, n, inetAddress2, n2, this.privKey, this.clientCerts, this.enabledCipherSuites, this.trustedCerts, this.cache, this.rand);
    }

    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    SecureRandom getRandom() {
        return this.rand;
    }

    SessionCache getSessionCache() {
        return this.cache;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    Vector getTrustedCertificates() {
        return this.trustedCerts;
    }

    protected void initializeKeys() throws SSLKeyException {
    }

    public void setClientCertificates(Vector vector) {
        this.clientCerts = vector;
    }

    public void setClientPrivateKey(PrivateKey privateKey) {
        this.privKey = privateKey;
    }

    public void setDefaultCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public void setTrustedCertificates(Vector vector) {
        this.trustedCerts = vector;
    }
}

