/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import java.util.Vector;

final class Certificate
extends HandShake {
    private byte[] encCerts;

    protected Certificate(HandShaker handShaker, Vector vector) throws IOException {
        this.handShaker = handShaker;
        this.msgType = (byte)11;
        this.encCerts = this.handShaker.processSenderCerts(vector);
        this.bodyLength = 3 + this.encCerts.length;
    }

    protected Certificate(HandShaker handShaker, byte[] byArray) throws IOException {
        super(handShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ Certificate");
        }
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.encCerts = xDRInputStream.readVector(3);
        this.handShaker.processReceivedCerts(this.encCerts);
    }

    protected void writeBody(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.writeVector(3, this.encCerts);
    }
}

