/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import java.util.Vector;

final class CertificateRequest
extends HandShake {
    protected static final byte RSA_SIGN = 1;
    protected static final byte DSS_SIGN = 2;
    protected static final byte RSA_FIXED_DH = 3;
    protected static final byte DSS_FIXED_DH = 4;
    protected static final byte RSA_EPHEMERAL_DH = 5;
    protected static final byte DSS_EPHEMERAL_DH = 6;
    protected static final byte FORTEZZA_KEA = 7;
    private byte[] certTypes;
    private byte[] cas;

    protected CertificateRequest(ClientHandShaker clientHandShaker, byte[] byArray) throws IOException {
        super(clientHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ CertificateRequest");
        }
    }

    protected CertificateRequest(ServerHandShaker serverHandShaker, byte[] byArray, Vector vector) throws IOException {
        this.handShaker = serverHandShaker;
        this.msgType = (byte)13;
        this.certTypes = byArray;
        this.cas = serverHandShaker.processAcceptableCAs(vector);
        this.bodyLength = 3 + this.certTypes.length + this.cas.length;
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.certTypes = xDRInputStream.readVector(1);
        this.cas = xDRInputStream.readVector(2);
        ((ClientHandShaker)this.handShaker).processAcceptableCAs(this.cas);
    }

    protected void writeBody(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.writeVector(1, this.certTypes);
        xDROutputStream.writeVector(2, this.cas);
    }
}

