/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;

final class CertificateVerify
extends HandShake {
    private byte[] signature;

    protected CertificateVerify(ClientHandShaker clientHandShaker) {
        this.handShaker = clientHandShaker;
        this.msgType = (byte)15;
        try {
            this.signature = clientHandShaker.generateClientSignature();
            this.bodyLength = this.signature.length + 2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected CertificateVerify(ServerHandShaker serverHandShaker, byte[] byArray) throws IOException {
        super(serverHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ CertificateVerify");
        }
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.signature = xDRInputStream.readVector(2);
        this.bodyLength = this.signature.length + 2;
        try {
            ((ServerHandShaker)this.handShaker).verifyClientSignature(this.signature);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    protected void writeBody(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.writeVector(2, this.signature);
    }
}

