/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Alert;
import com.dstc.security.ssl.Certificate;
import com.dstc.security.ssl.CertificateVerify;
import com.dstc.security.ssl.ChangeCipherSpec;
import com.dstc.security.ssl.ClientHello;
import com.dstc.security.ssl.DHClientKeyExchange;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.Finished;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.RSAClientKeyExchange;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.SSLSession;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;

final class ClientHandShaker
extends HandShaker {
    private Vector clientCerts;
    private int expectedContentType;

    protected ClientHandShaker(SSLSocket sSLSocket, SecureRandom secureRandom, PrivateKey privateKey, Vector vector, Vector vector2) throws SSLException {
        super(sSLSocket, secureRandom, vector2);
        this.clientCerts = vector;
        if (privateKey == null) {
            return;
        }
        if (privateKey.getAlgorithm().equals("RSA") || privateKey.getAlgorithm().equals("DSA")) {
            this.clientSigningKey = privateKey;
        } else {
            this.clientKeyXKey = privateKey;
        }
    }

    protected void changeReadCipher() throws SSLException {
        this.ctx.setKeyData(1, 0, this.keyBlock, this.serverHelloRandom, this.clientHelloRandom);
    }

    protected void changeWriteCipher() throws SSLException {
        this.ctx.setKeyData(0, 1, this.keyBlock, this.serverHelloRandom, this.clientHelloRandom);
    }

    protected final byte[] generateClientSignature() throws IOException {
        try {
            String string = this.clientSigningKey.getAlgorithm();
            Signature signature = Signature.getInstance("Raw" + string);
            signature.initSign((PrivateKey)this.clientSigningKey, this.rand);
            signature.update(this.toBeSignedCV(string));
            return signature.sign();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected byte[] getClientDiffieHellmanPublic() throws IOException {
        try {
            Object object;
            Object object2;
            DHPublicKey dHPublicKey = null;
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.serverKeyXKey.getEncoded());
            DHPublicKey dHPublicKey2 = (DHPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            if (this.clientKeyXKey != null) {
                x509EncodedKeySpec = new X509EncodedKeySpec(((X509Certificate)this.clientCerts.elementAt(0)).getPublicKey().getEncoded());
                dHPublicKey = (DHPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            } else {
                object2 = KeyPairGenerator.getInstance("DH");
                ((KeyPairGenerator)object2).initialize(dHPublicKey2.getParams(), this.rand);
                object = ((KeyPairGeneratorSpi)object2).generateKeyPair();
                this.clientKeyXKey = ((KeyPair)object).getPrivate();
                dHPublicKey = (DHPublicKey)((KeyPair)object).getPublic();
            }
            object2 = KeyAgreement.getInstance("DH");
            ((KeyAgreement)object2).init(this.clientKeyXKey, this.rand);
            ((KeyAgreement)object2).doPhase(dHPublicKey2, true);
            object = ((KeyAgreement)object2).generateSecret();
            if (Debug.debug >= 3) {
                Debug.debug("preMasterSecret: ", (byte[])object);
            }
            this.computeMasterSecret((byte[])object);
            byte[] byArray = dHPublicKey.getY().toByteArray();
            if (Debug.debug >= 3) {
                Debug.debug("exchangeKeys: ", byArray);
            }
            if (byArray[0] == 0) {
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                return byArray2;
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected byte[] getClientHelloRandom() {
        this.clientHelloRandom = new byte[32];
        this.rand.nextBytes(this.clientHelloRandom);
        long l = Calendar.getInstance().getTime().getTime();
        this.clientHelloRandom[0] = (byte)(l >> 24 & 0xFFL);
        this.clientHelloRandom[1] = (byte)(l >> 16 & 0xFFL);
        this.clientHelloRandom[2] = (byte)(l >> 8 & 0xFFL);
        this.clientHelloRandom[3] = (byte)(l & 0xFFL);
        return (byte[])this.clientHelloRandom.clone();
    }

    protected byte[] getEncryptedPreMasterSecret() throws IOException {
        byte[] byArray = new byte[48];
        this.rand.nextBytes(byArray);
        System.arraycopy(this.protocolVersion, 0, byArray, 0, 2);
        if (Debug.debug >= 3) {
            Debug.debug("preMasterSecret: ", byArray);
        }
        this.computeMasterSecret(byArray);
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, this.serverKeyXKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected byte[] getSessionID() {
        SSLSession sSLSession = this.socket.getSessionCache().getFirstValidSession();
        if (sSLSession == null) {
            this.offeredId = new byte[0];
        } else {
            this.offeredId = sSLSession.getId();
            this.masterSecret = sSLSession.getMasterSecret();
        }
        return this.offeredId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void nextMessage(SSLProtocolUnit sSLProtocolUnit) throws IOException {
        if (sSLProtocolUnit.getContentType() == 22) {
            byte by = ((HandShake)sSLProtocolUnit).getMessageType();
            switch (by) {
                case 0: {
                    this.startHandShake();
                    return;
                }
                case 2: {
                    if (this.offeredId.length <= 0 || !Arrays.equals(this.offeredId, this.currentId)) return;
                    this.sessionReuse = true;
                    this.computeKeyBlock();
                    return;
                }
                case 13: {
                    this.clientAuthRequired = true;
                    return;
                }
                case 14: {
                    if (this.clientAuthRequired) {
                        if (this.clientCerts == null) {
                            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 41));
                            this.handShakeState = 3;
                            throw new IOException("No client certificate");
                        }
                        Certificate certificate = new Certificate((HandShaker)this, this.clientCerts);
                        this.ctx.getOutputStream().writeProtocolUnit(certificate);
                    }
                    if (this.serverKeyXKey.getAlgorithm().equals("RSA")) {
                        RSAClientKeyExchange rSAClientKeyExchange = new RSAClientKeyExchange(this);
                        this.ctx.getOutputStream().writeProtocolUnit(rSAClientKeyExchange);
                    } else {
                        DHClientKeyExchange dHClientKeyExchange = new DHClientKeyExchange(this);
                        this.ctx.getOutputStream().writeProtocolUnit(dHClientKeyExchange);
                    }
                    if (this.clientAuthRequired && this.clientSigningKey != null) {
                        CertificateVerify certificateVerify = new CertificateVerify(this);
                        this.ctx.getOutputStream().writeProtocolUnit(certificateVerify);
                    }
                    this.ctx.getOutputStream().writeProtocolUnit(new ChangeCipherSpec());
                    if (Debug.debug >= 1) {
                        Debug.debug("Sent ChangeCipherSpec");
                    }
                    this.computeKeyBlock();
                    this.changeWriteCipher();
                    Finished finished = new Finished(this);
                    this.ctx.getOutputStream().writeProtocolUnit(finished);
                    return;
                }
                case 20: {
                    if (this.sessionReuse) {
                        this.ctx.getOutputStream().writeProtocolUnit(new ChangeCipherSpec());
                        this.changeWriteCipher();
                        this.ctx.getOutputStream().writeProtocolUnit(new Finished(this));
                    }
                    this.handShakeState = 2;
                    this.signalHandshakeCompleted();
                    return;
                }
                default: {
                    this.handShakeState = 3;
                    this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 10));
                    throw new SSLProtocolException("Bad message");
                }
                case 11: 
                case 12: {
                    return;
                }
            }
        }
        if (sSLProtocolUnit.getContentType() == 20) {
            this.changeReadCipher();
            return;
        } else {
            if (sSLProtocolUnit.getContentType() != 21) return;
            this.handShakeState = 3;
            throw new SSLHandshakeException("handshake failure");
        }
    }

    protected final void processAcceptableCAs(byte[] byArray) throws IOException {
        try {
            XDRInputStream xDRInputStream = new XDRInputStream(new ByteArrayInputStream(byArray));
            while (xDRInputStream.available() != 0) {
                byte[] byArray2 = xDRInputStream.readVector(2);
                X500Name x500Name = new X500Name(byArray2);
                if (Debug.debug < 1) continue;
                x500Name.info();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLHandshakeException(exception.getMessage());
        }
    }

    protected void setPubKeyBitLength(X509Certificate x509Certificate) throws IOException {
        try {
            String string = x509Certificate.getPublicKey().getAlgorithm();
            if (string.equals("RSA")) {
                this.pubKeyBitLength = ((RSAPublicKey)x509Certificate.getPublicKey()).getModulus().bitLength();
            } else if (string.equals("DSA")) {
                this.pubKeyBitLength = ((DSAPublicKey)x509Certificate.getPublicKey()).getParams().getP().bitLength();
            } else {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(x509Certificate.getPublicKey().getEncoded());
                DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
                this.pubKeyBitLength = dHPublicKey.getParams().getP().bitLength();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLKeyException(exception.getMessage());
        }
    }

    protected void setServerEncryptionKey(byte[] byArray, byte[] byArray2) throws IOException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.serverKeyXKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(new BigInteger(1, byArray), new BigInteger(1, byArray2)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected void setServerEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            this.serverKeyXKey = (DHPublicKey)keyFactory.generatePublic(new DHPublicKeySpec(new BigInteger(1, byArray3), new BigInteger(1, byArray), new BigInteger(1, byArray2)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected void setSessionId(byte[] byArray) {
        this.currentId = byArray;
    }

    protected void startHandShake() throws IOException {
        this.reset();
        this.handShakeState = 1;
        ClientHello clientHello = new ClientHello(this);
        this.ctx.getOutputStream().writeProtocolUnit(clientHello);
    }

    protected final void verifyServerSignature(byte[] byArray, byte[] byArray2) throws IOException {
        try {
            String string = this.serverSigningKey.getAlgorithm();
            Signature signature = Signature.getInstance("Raw" + string);
            signature.initVerify((PublicKey)this.serverSigningKey);
            signature.update(this.toBeSignedSKX(byArray, string));
            if (!signature.verify(byArray2)) {
                this.handShakeState = 3;
                this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
                throw new SSLHandshakeException("Bad signature");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLHandshakeException(exception.getMessage());
        }
    }
}

