/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLException;

final class ClientHello
extends HandShake {
    private byte[] version;
    private byte[] compression;
    private byte[] random;
    private byte[] sessionId;
    private Vector cipherSuites;

    protected ClientHello(ClientHandShaker clientHandShaker) throws IOException {
        this.handShaker = clientHandShaker;
        this.msgType = 1;
        this.version = clientHandShaker.getProtocolVersion();
        this.compression = clientHandShaker.getCompressionMethods();
        this.sessionId = clientHandShaker.getSessionID();
        this.random = clientHandShaker.getClientHelloRandom();
        this.cipherSuites = clientHandShaker.getEnabledCipherSuites();
        if (this.cipherSuites == null) {
            throw new SSLException("No enabled cipher suites to offer");
        }
        if (Debug.debug >= 1) {
            Debug.debug("\nOffering Cipher Suites");
            Iterator iterator = ((AbstractList)this.cipherSuites).iterator();
            while (iterator.hasNext()) {
                Debug.debug(CipherSuites.getSuiteName((byte[])iterator.next()));
            }
            Debug.debug("");
        }
        this.bodyLength = 34 + (1 + this.sessionId.length) + (2 + 2 * this.cipherSuites.size()) + (1 + this.compression.length);
    }

    protected ClientHello(HandShaker handShaker, byte[] byArray) throws IOException {
        super(handShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ ClientHello");
        }
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.version = xDRInputStream.readBytes(2);
        this.handShaker.setProtocolVersion(this.version);
        this.random = xDRInputStream.readBytes(32);
        ((ServerHandShaker)this.handShaker).setClientHelloRandom(this.random);
        this.sessionId = xDRInputStream.readVector(1);
        ((ServerHandShaker)this.handShaker).setSessionId(this.sessionId);
        int n = xDRInputStream.readShort() / 2;
        this.cipherSuites = new Vector();
        int n2 = 0;
        while (n2 < n) {
            this.cipherSuites.addElement(xDRInputStream.readBytes(2));
            ++n2;
        }
        ((ServerHandShaker)this.handShaker).setCipherSuite(this.cipherSuites);
        this.compression = xDRInputStream.readVector(1);
    }

    protected void writeBody(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.write(this.version);
        xDROutputStream.write(this.random);
        xDROutputStream.writeVector(1, this.sessionId);
        xDROutputStream.writeShort(2 * this.cipherSuites.size());
        int n = 0;
        while (n < this.cipherSuites.size()) {
            xDROutputStream.write((byte[])this.cipherSuites.elementAt(n));
            ++n;
        }
        xDROutputStream.writeVector(1, this.compression);
    }
}

