/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.ClientKeyExchange;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import java.io.IOException;

class DHClientKeyExchange
extends ClientKeyExchange {
    protected DHClientKeyExchange(ClientHandShaker clientHandShaker) throws IOException {
        this.handShaker = clientHandShaker;
        this.msgType = (byte)16;
        this.exchangeKeys = clientHandShaker.getClientDiffieHellmanPublic();
        this.bodyLength = this.exchangeKeys.length;
    }

    protected DHClientKeyExchange(ServerHandShaker serverHandShaker, byte[] byArray) throws IOException {
        super(serverHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ DHClientKeyExchange");
        }
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.exchangeKeys = xDRInputStream.readBytes((this.handShaker.getPubKeyBitLength() + 4) / 8);
        ((ServerHandShaker)this.handShaker).setMasterSecret(this.exchangeKeys);
    }
}

