/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.ServerKeyExchange;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import javax.crypto.interfaces.DHPublicKey;

final class DHServerKeyExchange
extends ServerKeyExchange {
    protected DHServerKeyExchange(ClientHandShaker clientHandShaker, byte[] byArray) throws IOException {
        super(clientHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ DHServerKeyExchange");
        }
    }

    protected DHServerKeyExchange(ServerHandShaker serverHandShaker, int n) throws IOException {
        super(serverHandShaker, n);
    }

    protected void generateParamsAndSig(XDROutputStream xDROutputStream) throws IOException {
        DHPublicKey dHPublicKey = ((ServerHandShaker)this.handShaker).generateTempDHPubKey(this.keyLength);
        byte[] byArray = dHPublicKey.getParams().getP().toByteArray();
        byte[] byArray2 = dHPublicKey.getParams().getG().toByteArray();
        byte[] byArray3 = dHPublicKey.getY().toByteArray();
        xDROutputStream.writeVector(2, byArray);
        xDROutputStream.writeVector(2, byArray2);
        xDROutputStream.writeVector(2, byArray3);
    }

    protected void verifyParamsSig(XDRInputStream xDRInputStream, XDROutputStream xDROutputStream) throws IOException {
        byte[] byArray = xDRInputStream.readVector(2);
        byte[] byArray2 = xDRInputStream.readVector(2);
        byte[] byArray3 = xDRInputStream.readVector(2);
        ((ClientHandShaker)this.handShaker).setServerEncryptionKey(byArray, byArray2, byArray3);
        xDROutputStream.writeVector(2, byArray);
        xDROutputStream.writeVector(2, byArray2);
        xDROutputStream.writeVector(2, byArray3);
    }
}

