/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Certificate;
import com.dstc.security.ssl.CertificateRequest;
import com.dstc.security.ssl.CertificateVerify;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.ClientHello;
import com.dstc.security.ssl.DHClientKeyExchange;
import com.dstc.security.ssl.DHServerKeyExchange;
import com.dstc.security.ssl.Finished;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.HelloRequest;
import com.dstc.security.ssl.RSAClientKeyExchange;
import com.dstc.security.ssl.RSAServerKeyExchange;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.ServerHello;
import com.dstc.security.ssl.ServerHelloDone;
import com.dstc.security.ssl.V3Message;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;

abstract class HandShake
extends V3Message {
    protected static final byte HELLO_REQUEST = 0;
    protected static final byte CLIENT_HELLO = 1;
    protected static final byte SERVER_HELLO = 2;
    protected static final byte CERTIFICATE = 11;
    protected static final byte SERVER_KEY_EXCHANGE = 12;
    protected static final byte CERTIFICATE_REQUEST = 13;
    protected static final byte SERVER_HELLO_DONE = 14;
    protected static final byte CERTIFICATE_VERIFY = 15;
    protected static final byte CLIENT_KEY_EXCHANGE = 16;
    protected static final byte FINISHED = 20;
    protected byte msgType;
    protected int bodyLength;
    protected HandShaker handShaker;

    protected HandShake() {
        this.contentType = (byte)22;
    }

    protected HandShake(HandShaker handShaker, byte[] byArray) throws IOException {
        this();
        this.handShaker = handShaker;
        XDRInputStream xDRInputStream = new XDRInputStream(new ByteArrayInputStream(byArray));
        this.msgType = xDRInputStream.readByte();
        this.bodyLength = xDRInputStream.read3Bytes();
        this.readBody(xDRInputStream);
        handShaker.updateHashes(byArray);
    }

    protected static HandShake getInstance(HandShaker handShaker, byte[] byArray) throws IOException {
        byte by = byArray[0];
        switch (by) {
            case 0: {
                return new HelloRequest((ClientHandShaker)handShaker, byArray);
            }
            case 1: {
                return new ClientHello((ServerHandShaker)handShaker, byArray);
            }
            case 2: {
                return new ServerHello((ClientHandShaker)handShaker, byArray);
            }
            case 11: {
                return new Certificate(handShaker, byArray);
            }
            case 13: {
                return new CertificateRequest((ClientHandShaker)handShaker, byArray);
            }
            case 15: {
                return new CertificateVerify((ServerHandShaker)handShaker, byArray);
            }
            case 12: {
                if (handShaker.isDiffieHellmanKeyX()) {
                    return new DHServerKeyExchange((ClientHandShaker)handShaker, byArray);
                }
                return new RSAServerKeyExchange((ClientHandShaker)handShaker, byArray);
            }
            case 14: {
                return new ServerHelloDone((ClientHandShaker)handShaker, byArray);
            }
            case 16: {
                if (handShaker.isDiffieHellmanKeyX()) {
                    return new DHClientKeyExchange((ServerHandShaker)handShaker, byArray);
                }
                return new RSAClientKeyExchange((ServerHandShaker)handShaker, byArray);
            }
            case 20: {
                return new Finished(handShaker, byArray);
            }
        }
        throw new SSLHandshakeException("Unknown handshake message type: " + by);
    }

    public int getLength() {
        return this.bodyLength + 4;
    }

    protected byte getMessageType() {
        return this.msgType;
    }

    protected abstract void readBody(XDRInputStream var1) throws IOException;

    protected void write(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.writeByte(this.msgType);
        xDROutputStream.write3Bytes(this.bodyLength);
        this.writeBody(xDROutputStream);
    }

    protected abstract void writeBody(XDROutputStream var1) throws IOException;
}

