/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Alert;
import com.dstc.security.ssl.ApplicationData;
import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.SSLSession;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.TrustEngine;
import com.dstc.security.ssl.V3Constants;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

abstract class HandShaker {
    static final int CLIENT = 0;
    static final int SERVER = 1;
    protected static final int HANDSHAKE_NOT_YET_BEGUN = 0;
    protected static final int HANDSHAKE_IN_PROGRESS = 1;
    protected static final int HANDSHAKE_COMPLETED = 2;
    protected static final int HANDSHAKE_BAD_COMPLETION = 3;
    protected SSLContext ctx;
    protected SSLSocket socket;
    private Vector listeners = new Vector();
    private MessageDigest md5Hash;
    private MessageDigest shaHash;
    protected int pubKeyBitLength;
    protected SecureRandom rand;
    protected byte[] protocolVersion = V3Constants.VERSION;
    protected byte[] compressionMethods = V3Constants.COMPRESSION_METHODS;
    protected byte[] clientHelloRandom;
    protected byte[] serverHelloRandom;
    protected Key serverSigningKey;
    protected Key serverKeyXKey;
    protected Key clientSigningKey;
    protected Key clientKeyXKey;
    protected byte[] masterSecret;
    protected byte[] keyBlock;
    protected byte[] pendingCipherSuite;
    protected Vector enabledCipherSuites;
    protected boolean clientAuthRequired;
    private CertificateFactory certFact;
    private MessageDigest md5;
    private MessageDigest sha;
    private X509Certificate[] peerCertChain;
    protected int handShakeState;
    protected byte[] offeredId;
    protected byte[] currentId;
    protected boolean sessionReuse;
    protected TrustEngine trustEngine;
    private Object readLock;
    private Object writeLock;
    protected PreEmptor preEmptor;

    protected HandShaker(SSLSocket sSLSocket, SecureRandom secureRandom, Vector vector) throws SSLException {
        try {
            this.socket = sSLSocket;
            this.ctx = sSLSocket.getContext();
            this.rand = secureRandom;
            this.trustEngine = new TrustEngine(vector);
            this.certFact = CertificateFactory.getInstance("X509");
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA");
            this.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SSLException(exception.getMessage());
        }
    }

    void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.listeners.add(handshakeCompletedListener);
    }

    boolean badCompletion() {
        return this.handShakeState == 3;
    }

    protected abstract void changeReadCipher() throws SSLException;

    protected abstract void changeWriteCipher() throws SSLException;

    protected final void checkHashes(byte[] byArray) throws IOException {
        byte[] byArray2 = this instanceof ClientHandShaker ? this.computeHashes(1) : this.computeHashes(0);
        if (!Arrays.equals(byArray2, byArray)) {
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLHandshakeException("Bad handshake hashes");
        }
    }

    protected synchronized void cleanup() throws IOException {
        if (Debug.debug >= 1) {
            Debug.debug("start cleanup");
        }
        this.ctx.getOutputStream().writeProtocolUnit(new Alert(1, 0));
        if (Debug.debug >= 1) {
            Debug.debug("finish cleanup");
        }
    }

    protected final byte[] computeHashes(int n) throws IOException {
        return this.ctx.getMac().computeHashes(this.shaHash, this.md5Hash, this.masterSecret, n);
    }

    protected final void computeKeyBlock() {
        this.keyBlock = this.ctx.getMac().computeKeyBlock(this.masterSecret, this.clientHelloRandom, this.serverHelloRandom);
    }

    protected final void computeMasterSecret(byte[] byArray) {
        this.masterSecret = this.ctx.getMac().computeMasterSecret(byArray, this.clientHelloRandom, this.serverHelloRandom);
    }

    protected final byte[] generateHashes() throws IOException {
        if (this instanceof ClientHandShaker) {
            return this.computeHashes(0);
        }
        return this.computeHashes(1);
    }

    byte[] getCompressionMethods() {
        return this.compressionMethods;
    }

    protected Vector getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    byte[] getProtocolVersion() {
        return this.protocolVersion;
    }

    protected int getPubKeyBitLength() {
        return this.pubKeyBitLength;
    }

    protected abstract byte[] getSessionID();

    boolean handShakeCompleted() {
        return this.handShakeState == 2 || this.handShakeState == 3;
    }

    boolean handShakeNotYetBegun() {
        return this.handShakeState == 0;
    }

    boolean handShakeStarted() {
        return this.handShakeState == 1;
    }

    protected boolean isDiffieHellmanEphKeyX() {
        return this.ctx.getPendingKeyXAlgName().startsWith("DHE");
    }

    protected boolean isDiffieHellmanKeyX() {
        return this.ctx.getPendingKeyXAlgName().startsWith("DH");
    }

    protected boolean isExportable() {
        return this.ctx.isPendingExportable();
    }

    protected abstract void nextMessage(SSLProtocolUnit var1) throws IOException;

    protected void processReceivedCerts(byte[] byArray) throws IOException {
        try {
            Object object;
            Object object2;
            XDRInputStream xDRInputStream = new XDRInputStream(new ByteArrayInputStream(byArray));
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            while (xDRInputStream.available() != 0) {
                object2 = xDRInputStream.readVector(3);
                object = new ByteArrayInputStream((byte[])object2);
                vector.addElement((X509Certificate)this.certFact.generateCertificate((InputStream)object));
            }
            this.peerCertChain = new X509Certificate[vector.size()];
            vector.toArray(this.peerCertChain);
            this.trustEngine.verifyCertChain(this.peerCertChain);
            object2 = this.peerCertChain[0];
            object = ((Certificate)object2).getPublicKey();
            if (this instanceof ClientHandShaker) {
                if (object.getAlgorithm().equals("RSA") || object.getAlgorithm().equals("DSA")) {
                    this.serverSigningKey = object;
                }
                this.serverKeyXKey = object;
            } else if (object.getAlgorithm().equals("DH") || object.getAlgorithm().equals("Diffie-Hellman")) {
                this.clientKeyXKey = object;
            } else {
                this.clientSigningKey = object;
            }
            if (Debug.debug >= 1) {
                Debug.debug("\nReceived certs");
                int n = 0;
                while (n < this.peerCertChain.length) {
                    Debug.debug(this.peerCertChain[n].toString());
                    ++n;
                }
                Debug.debug("");
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 42));
            throw new SSLHandshakeException(certificateException.getMessage());
        }
    }

    protected byte[] processSenderCerts(Vector vector) throws IOException {
        if (vector == null) {
            throw new SSLException("No available certificate");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
            X509Certificate x509Certificate = (X509Certificate)vector.elementAt(0);
            this.setPubKeyBitLength(x509Certificate);
            xDROutputStream.writeVector(3, x509Certificate.getEncoded());
            int n = 1;
            while (n < vector.size()) {
                x509Certificate = (X509Certificate)vector.elementAt(n);
                xDROutputStream.writeVector(3, x509Certificate.getEncoded());
                ++n;
            }
            xDROutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException("Bad certificate encoding");
        }
    }

    protected void reset() throws SSLException {
        try {
            this.shaHash = MessageDigest.getInstance("SHA");
            this.md5Hash = MessageDigest.getInstance("MD5");
            this.pendingCipherSuite = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SSLException(exception.getMessage());
        }
    }

    void setCompressionMethods(byte[] byArray) {
        this.compressionMethods = byArray;
    }

    protected void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < CipherSuites.suiteName.length) {
                if (stringArray[n].equals(CipherSuites.suiteName[n2])) {
                    this.enabledCipherSuites.add(CipherSuites.suiteType[n2]);
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void setPendingCipherSuite(byte[] byArray) {
        this.pendingCipherSuite = byArray;
        this.ctx.setPendingCipherSpec(byArray);
    }

    void setProtocolVersion(byte[] byArray) {
        this.protocolVersion = byArray;
    }

    protected abstract void setPubKeyBitLength(X509Certificate var1) throws IOException;

    protected void setServerHelloRandom(byte[] byArray) {
        this.serverHelloRandom = byArray;
    }

    protected abstract void setSessionId(byte[] var1);

    void signalHandshakeCompleted() {
        SSLSession sSLSession;
        if (!this.sessionReuse) {
            sSLSession = new SSLSession(this.socket, this.currentId, this.masterSecret, CipherSuites.getSuiteName(this.pendingCipherSuite), this.peerCertChain);
            sSLSession.addToCache();
            if (Debug.debug >= 1) {
                System.out.println("\nNew session");
                System.out.println(sSLSession.toString());
            }
        } else {
            sSLSession = (SSLSession)this.socket.getSessionCache().getSession(this.currentId);
            sSLSession.updateAccessTime();
            this.socket.setSession(sSLSession);
            if (Debug.debug >= 1) {
                System.out.println("\nReusing session");
                System.out.println(sSLSession.toString());
            }
        }
        HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this.socket, sSLSession);
        int n = 0;
        while (n < this.listeners.size()) {
            ((HandshakeCompletedListener)this.listeners.elementAt(n)).handshakeCompleted(handshakeCompletedEvent);
            ++n;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.writeLock.notifyAll();
        }
        object = this.readLock;
        synchronized (object) {
            this.readLock.notifyAll();
        }
    }

    protected abstract void startHandShake() throws IOException;

    void startPreEmptor() {
        this.readLock = this.socket.getReadLock();
        this.writeLock = this.socket.getWriteLock();
        this.preEmptor = new PreEmptor();
        this.preEmptor.setDaemon(true);
        this.preEmptor.start();
    }

    protected final byte[] toBeSignedCV(String string) throws IOException {
        if (string.equals("RSA")) {
            return this.ctx.getMac().hash(this.shaHash, this.md5Hash, this.masterSecret, null, 0);
        }
        return this.ctx.getMac().hash(this.shaHash, this.md5Hash, this.masterSecret, null, 1);
    }

    protected final byte[] toBeSignedSKX(byte[] byArray, String string) {
        this.sha.update(this.clientHelloRandom);
        this.sha.update(this.serverHelloRandom);
        this.sha.update(byArray);
        byte[] byArray2 = this.sha.digest();
        if (string.equals("DSA")) {
            return byArray2;
        }
        this.md5.update(this.clientHelloRandom);
        this.md5.update(this.serverHelloRandom);
        this.md5.update(byArray);
        byte[] byArray3 = this.md5.digest();
        byte[] byArray4 = new byte[36];
        System.arraycopy(byArray3, 0, byArray4, 0, 16);
        System.arraycopy(byArray2, 0, byArray4, 16, 20);
        return byArray4;
    }

    protected void updateHashes(byte[] byArray) {
        this.md5Hash.update(byArray);
        this.shaHash.update(byArray);
    }

    private final class PreEmptor
    extends Thread {
        PreEmptor() {
        }

        public void run() {
            while (true) {
                Object object = HandShaker.this.readLock;
                synchronized (object) {
                    try {
                        while (HandShaker.this.handShakeState == 2) {
                            HandShaker.this.readLock.notifyAll();
                            HandShaker.this.readLock.wait();
                        }
                        do {
                            SSLProtocolUnit sSLProtocolUnit;
                            if ((sSLProtocolUnit = HandShaker.this.ctx.getInputStream().readProtocolUnit()) == null) {
                                HandShaker.this.handShakeState = 3;
                                HandShaker.this.readLock.notifyAll();
                                Object var2_4 = null;
                                return;
                            }
                            if (sSLProtocolUnit instanceof Alert || sSLProtocolUnit instanceof ApplicationData) continue;
                            HandShaker.this.ctx.nextHandShake(sSLProtocolUnit);
                        } while (!HandShaker.this.ctx.getInputStream().bufferEmpty());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        HandShaker.this.handShakeState = 3;
                        try {
                            HandShaker.this.ctx.getOutputStream().close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                        HandShaker.this.readLock.notifyAll();
                        Object var2_5 = null;
                        break;
                    }
                }
            }
        }
    }
}

