/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Alert;
import com.dstc.security.ssl.ApplicationData;
import com.dstc.security.ssl.ChangeCipherSpec;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.V2ClientHello;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLProtocolException;

final class ProtocolUnitInputStream
extends XDRInputStream {
    private SSLContext ctx;
    private ByteArrayInputStream puBuffer = new ByteArrayInputStream(new byte[0]);
    private byte[] packet;
    private boolean empty = true;
    private byte type;

    ProtocolUnitInputStream(SSLContext sSLContext, InputStream inputStream) {
        super(inputStream);
        this.ctx = sSLContext;
    }

    boolean bufferEmpty() {
        return this.empty || this.puBuffer.available() == 0;
    }

    SSLProtocolUnit readProtocolUnit() throws IOException {
        Object object;
        if (this.bufferEmpty()) {
            try {
                this.type = super.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            if (Debug.debug >= 2) {
                Debug.debug("Type: " + this.type);
            }
            if ((this.type & 0x80) == 128) {
                int n = (this.type & 0x7F) >> 8 | super.readByte();
                byte[] byArray = super.readBytes(n);
                return new V2ClientHello((ServerHandShaker)this.ctx.getHandShaker(), byArray);
            }
            object = super.readBytes(2);
            if (Debug.debug >= 2) {
                Debug.debug("Major, minor: " + (int)object[0] + ", " + (int)object[1]);
            }
            short s = super.readShort();
            if (Debug.debug >= 2) {
                Debug.debug("Record length: " + s);
            }
            this.packet = this.ctx.decryptAndVerifyMac(this.type, super.readBytes(s));
            this.puBuffer = new ByteArrayInputStream(this.packet);
            this.empty = false;
        }
        switch (this.type) {
            case 20: {
                this.empty = true;
                return new ChangeCipherSpec(this.packet);
            }
            case 21: {
                this.empty = true;
                return new Alert(this.packet);
            }
            case 23: {
                this.empty = true;
                return new ApplicationData(this.packet);
            }
            case 22: {
                object = new XDRInputStream(this.puBuffer);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
                xDROutputStream.writeByte(((DataInputStream)object).readByte());
                int n = ((XDRInputStream)object).read3Bytes();
                xDROutputStream.write3Bytes(n);
                xDROutputStream.write(((XDRInputStream)object).readBytes(n));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (Debug.debug >= 2) {
                    Debug.debug("Content length: " + byArray.length);
                }
                return HandShake.getInstance(this.ctx.getHandShaker(), byArray);
            }
        }
        throw new SSLProtocolException("Bad ContentType received");
    }
}

