/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class ProtocolUnitOutputStream
extends XDROutputStream {
    private SSLContext ctx;

    ProtocolUnitOutputStream(SSLContext sSLContext, OutputStream outputStream) {
        super(outputStream);
        this.ctx = sSLContext;
    }

    synchronized void writeProtocolUnit(SSLProtocolUnit sSLProtocolUnit) throws IOException {
        byte[] byArray = sSLProtocolUnit.getBytes();
        if (sSLProtocolUnit instanceof HandShake) {
            this.ctx.getHandShaker().updateHashes(byArray);
        }
        byArray = this.ctx.macAndEncrypt(sSLProtocolUnit.getContentType(), byArray);
        super.writeByte(sSLProtocolUnit.getContentType());
        super.write(this.ctx.getHandShaker().getProtocolVersion());
        super.writeShort(byArray.length);
        super.write(byArray);
        this.flush();
        if (Debug.debug >= 2) {
            Debug.debug("Sent message: " + sSLProtocolUnit);
        }
    }
}

