/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.ClientKeyExchange;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import java.io.IOException;

final class RSAClientKeyExchange
extends ClientKeyExchange {
    protected RSAClientKeyExchange(ClientHandShaker clientHandShaker) throws IOException {
        this.handShaker = clientHandShaker;
        this.msgType = (byte)16;
        this.exchangeKeys = clientHandShaker.getEncryptedPreMasterSecret();
        this.bodyLength = this.exchangeKeys.length;
    }

    protected RSAClientKeyExchange(ServerHandShaker serverHandShaker, byte[] byArray) throws IOException {
        super(serverHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ RSAClientKeyExchange");
        }
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.exchangeKeys = this.handShaker.isExportable() ? xDRInputStream.readBytes(64) : xDRInputStream.readBytes((this.handShaker.getPubKeyBitLength() + 4) / 8);
        ((ServerHandShaker)this.handShaker).setMasterSecret(this.exchangeKeys);
    }
}

